package csbase.logic.algorithms.xml.category;

import tecgraf.javautils.xml.XMLBasicHandler;
import csbase.logic.algorithms.CategorySet;

/**
 * Handler XML para leitura de categorias de algoritmos.
 * 
 */
public class XmlCategoriesHandler extends XMLBasicHandler {

  /**
   * Constri o handler.
   * 
   * @param categorySet conjunto de categorias de algoritmos
   */
  public XmlCategoriesHandler(CategorySet categorySet) {
    super(new XmlCategoriesFactory(categorySet));
  }

  /**
   * Obtm a referncia para o conjunto de categorias.
   * 
   * @return a referncia para o conjunto de categorias
   */
  final public CategorySet getCategorySet() {
    return (CategorySet) getXMLFactory().getAppContextObject();
  }
}