package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro nulo, ou seja, todos os arquivos so aceitos.
 * 
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public final class ProjectFileNullFilter implements ProjectFileFilter {
  /**
   * Instncia do filtro.
   */
  private static final ProjectFileNullFilter instance =
    new ProjectFileNullFilter();

  /**
   * Construtor.
   */
  private ProjectFileNullFilter() {
    // vazio
  }

  /**
   * @return instncia do filtro
   */
  public static ProjectFileNullFilter getInstance() {
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  public boolean accept(ClientProjectFile file) {
    return true;
  }
}
