package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

/**
 * Define um filtro que aceita apenas arquivos de determinados tipos. Caso um
 * dos tipos da lista seja null, todos os arquivos passados sero aceitos.
 *
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public final class ProjectFileTypeFilter implements ProjectFileFilter {
  /** Os tipos dos arquivos que sero aceitos. */
  private String[] fileType;

  /**
   * Constri um filtro de tipos de arquivo.
   *
   * @param fileType O tipo dos arquivos que sero aceitos.
   */
  public ProjectFileTypeFilter(String fileType) {
    this.fileType = new String[] { fileType };
  }

  /**
   * Constri um filtro de tipos de arquivo.
   *
   * @param fileType Os tipos dos arquivos que sero aceitos.
   */
  public ProjectFileTypeFilter(String[] fileType) {
    this.fileType = fileType;
  }

  public boolean accept(ClientProjectFile file) {
    if (file.isDirectory()) {
      return false;
    }
    if (this.fileType == null) {
      return true;
    }
    for (int i = 0; i < this.fileType.length; i++) {
      String type = this.fileType[i];
      if ((type == null) || (file.getType().equals(type))) {
        return true;
      }
    }
    return false;
  }
}
