package csbase.logic.algorithms.parsers;

import java.util.EnumSet;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import csbase.logic.algorithms.parameters.FileURLValue;

/**
 * Analisador de parmetros URL de sada.
 *
 * @author Tecgraf
 */
public class OutputURLParameterParser extends
  AbstractURLParameterParser<OutputURLParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  public OutputURLParameter createSimpleParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, ParameterGroup group)
    throws ParseException {

    String type = parser.extractAttributeValue(TYPE_ATTRIBUTE, null);
    String localization = parser.extractAttributeValue(LOCALIZATION_ATTRIBUTE);

    FileParameterPipeAcceptance usesPipe =
      parser.extractAttributeValueAsEnumeration(CAN_USE_PIPE_ATTRIBUTE,
        CAN_USE_PIPE_DEFAULT_VALUE, new URLParameterPipeAcceptanceConverter());

    String modeName =
      parser.extractAttributeValue(CATEGORY_ATTRIBUTE,
        CATEGORY_VALUE_REGULAR_FILE);

    if (!modeName.equals(CATEGORY_VALUE_DIRECTORY)
      && !modeName.equals(CATEGORY_VALUE_REGULAR_FILE)) {
      throw new ParseException("A categoria informada {0} no  vlida.\n"
        + "Categorias vlidas:\n{1};\n{2}.", modeName,
        CATEGORY_VALUE_REGULAR_FILE, CATEGORY_VALUE_DIRECTORY);
    }

    FileParameterMode mode = FileParameterMode.DIRECTORY;
    if (modeName.equals(CATEGORY_VALUE_REGULAR_FILE)) {
      mode = FileParameterMode.REGULAR_FILE;
    }

    boolean useRootDirectoryAsDefault =
      parser.extractAttributeValueAsBoolean(DEFAULT_DIRECTORY_ATTRIBUTE,
        DEFAULT_DIRECTORY_DEFAULT_VALUE);
    FileURLValue defaultValue = null;
    if (useRootDirectoryAsDefault) {
      if (mode == FileParameterMode.REGULAR_FILE) {
        throw new ParseException(
          "O atributo {0}  invlido quando o parmetro de sada  um arquivo.",
          DEFAULT_DIRECTORY_ATTRIBUTE);
      }
      defaultValue = new FileURLValue(".");
    }

    String protocols = parser.extractAttributeValue(PROTOCOLS_ATTRIBUTE, null);
    EnumSet<URLProtocol> allowedProtocols;
    if (protocols != null) {
      allowedProtocols = EnumSet.noneOf(URLProtocol.class);
      String[] protocolsAsArray = protocols.split(",");
      URLProtocolConverter converter = new URLProtocolConverter();
      for (String protocolString : protocolsAsArray) {
        URLProtocol protocol = converter.valueOf(protocolString);
        allowedProtocols.add(protocol);
      }
    }
    else {
      allowedProtocols = EnumSet.allOf(URLProtocol.class);
    }

    return new OutputURLParameter(name, label, description, defaultValue,
      isOptional, isVisible, commandLinePattern, localization, type, mode,
      usesPipe, allowedProtocols);
  }
}
