/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import tecgraf.javautils.version.VersionNumber;

public class ManifestVersion {
    public static final String BAD_VERSION_NAME = "??.??.??";
    private VersionNumber versionNumber;

    public ManifestVersion(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz cannot be nul.");
        }
        this.versionNumber = this.readVersion(clazz);
    }

    protected VersionNumber readVersion(Class<?> clazz) {
        String versionString = clazz.getPackage().getImplementationVersion();
        if (versionString != null) {
            return VersionNumber.fromString((String)versionString);
        }
        return null;
    }

    public final String getVersionName() {
        return this.versionNumber == null ? BAD_VERSION_NAME : this.versionNumber.toString();
    }

    public final int getMajorVersion() {
        return this.versionNumber == null ? -1 : this.versionNumber.getMajor();
    }

    public final int getMinorVersion() {
        return this.versionNumber == null ? -1 : this.versionNumber.getMinor();
    }

    public final int getPatchVersion() {
        return this.versionNumber == null ? -1 : this.versionNumber.getPatch();
    }
}

