/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows.configurator;

import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandScript;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.FlowCommandLineContext;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.flows.configurator.Input;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.logic.algorithms.flows.configurator.Output;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.validation.FlowNodeValidationResult;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.io.FileUtils;

public final class FlowAlgorithmConfigurator
extends AlgorithmConfigurator {
    private static final String QUOTE = "\"";
    private static final int NODE_ID_INDEX = 1;
    private static final String PARAMETER_NAME_REGEX = "([0-9]*)\\.(.*)";
    private static final int REAL_PARAMETER_NAME_INDEX = 2;
    private Flow flow;
    private FileURLValue guiltyNodeLog;
    private Map<Integer, Node> nodesById;
    private boolean canBeExecuted;

    public FlowAlgorithmConfigurator(AlgorithmVersionInfo algorithmVersion, Flow flow) {
        super(AlgorithmConfigurator.ConfiguratorType.FLOW, algorithmVersion, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, "FLOWABBR", false, null);
        this.setFlow(flow);
    }

    public FlowAlgorithmConfigurator(String filePath, Flow flow) {
        super(AlgorithmConfigurator.ConfiguratorType.FLOW, filePath, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, "FLOWABBR", false, null);
        this.setFlow(flow);
    }

    public FlowAlgorithmConfigurator(Flow flow) {
        super(AlgorithmConfigurator.ConfiguratorType.FLOW, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, "FLOWABBR", false, null);
        this.setFlow(flow);
    }

    @Override
    public Map<Object, Object> exportValues() {
        HashMap<Object, Object> values = new HashMap<Object, Object>();
        for (Node node : this.nodesById.values()) {
            values.put(node.getId(), node.getConfigurator().exportValues());
        }
        return values;
    }

    @Override
    public Set<String> getRequirements() {
        HashSet<String> requirementsSet = new HashSet<String>();
        for (Node node : this.nodesById.values()) {
            Set<String> requirements = node.getConfigurator().getRequirements();
            requirementsSet.addAll(requirements);
        }
        return requirementsSet;
    }

    @Override
    public Set<String[]> getBinaryDirectoriesAsArray(String platformId) {
        HashSet<String[]> binaryDirectories = new HashSet<String[]>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            binaryDirectories.addAll(configurator.getBinaryDirectoriesAsArray(platformId));
        }
        return binaryDirectories;
    }

    @Override
    public Set<String> getBinaryDirectories(String platformId, char fileSeparator) {
        HashSet<String> binaryDirectories = new HashSet<String>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            binaryDirectories.addAll(configurator.getBinaryDirectories(platformId, fileSeparator));
        }
        return binaryDirectories;
    }

    @Override
    public Set<FileURLValue> getInputDirectories() {
        HashSet<FileURLValue> directories = new HashSet<FileURLValue>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<FileURLValue> currentDirectories = configurator.getInputDirectories();
            directories.addAll(currentDirectories);
        }
        return Collections.unmodifiableSet(directories);
    }

    @Override
    public Set<FileURLValue> getOutputDirectories() {
        HashSet<FileURLValue> directories = new HashSet<FileURLValue>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<FileURLValue> currentDirectories = configurator.getOutputDirectories();
            directories.addAll(currentDirectories);
        }
        return Collections.unmodifiableSet(directories);
    }

    @Override
    public List<InputFileParameter> getInputFileParameters() {
        LinkedList<InputFileParameter> inputFileParameters = new LinkedList<InputFileParameter>();
        for (Node node : this.getNodes()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            inputFileParameters.addAll(configurator.getInputFileParameters());
        }
        return Collections.unmodifiableList(inputFileParameters);
    }

    @Override
    public Set<FileURLValue> getInputFiles() {
        HashSet<FileURLValue> inputFiles = new HashSet<FileURLValue>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<FileURLValue> currentInputFiles = configurator.getInputFiles();
            inputFiles.addAll(currentInputFiles);
        }
        return Collections.unmodifiableSet(inputFiles);
    }

    @Override
    public List<InputURLParameter> getInputURLParameters() {
        LinkedList<InputURLParameter> inputURLParameters = new LinkedList<InputURLParameter>();
        for (Node node : this.getNodes()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            inputURLParameters.addAll(configurator.getInputURLParameters());
        }
        return Collections.unmodifiableList(inputURLParameters);
    }

    @Override
    public Set<FileURLValue> getInputURLs() {
        HashSet<FileURLValue> inputURLs = new HashSet<FileURLValue>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<FileURLValue> currentInputURLs = configurator.getInputURLs();
            inputURLs.addAll(currentInputURLs);
        }
        return Collections.unmodifiableSet(inputURLs);
    }

    public Flow getFlow() {
        return this.flow;
    }

    public FileURLValue getGuiltyNodeLog() {
        return this.guiltyNodeLog;
    }

    public void setGuiltyNodeLog(FileURLValue guiltyNodeLog) {
        this.guiltyNodeLog = guiltyNodeLog;
    }

    @Override
    public Set<FileURLValue> getLogFiles() {
        HashSet<FileURLValue> logFiles = new HashSet<FileURLValue>();
        for (Node node : this.getNodes()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)configurator;
                logFiles.addAll(flowConfigurator.getLogFiles());
                continue;
            }
            FileURLValue logFile = configurator.getLogFile();
            if (logFile == null) continue;
            logFiles.add(logFile);
        }
        return Collections.unmodifiableSet(logFiles);
    }

    public String getName() {
        return this.flow.getName();
    }

    public Node getNode(int id) {
        return this.nodesById.get(id);
    }

    public Set<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.addAll(this.nodesById.values());
        return Collections.unmodifiableSet(nodes);
    }

    public boolean hasBypassedNodes() {
        for (FlowNode node : this.flow.getNodes()) {
            if (!node.isBypassed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<OutputFileParameter> getOutputFileParameters() {
        LinkedList<OutputFileParameter> outputFileParameters = new LinkedList<OutputFileParameter>();
        for (Node node : this.getNodes()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            outputFileParameters.addAll(configurator.getOutputFileParameters());
        }
        return Collections.unmodifiableList(outputFileParameters);
    }

    @Override
    public Set<FileURLValue> getOutputFiles() {
        HashSet<FileURLValue> outputFiles = new HashSet<FileURLValue>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<FileURLValue> currentOutputFiles = configurator.getOutputFiles();
            outputFiles.addAll(currentOutputFiles);
        }
        return Collections.unmodifiableSet(outputFiles);
    }

    @Override
    public List<OutputURLParameter> getOutputURLParameters() {
        LinkedList<OutputURLParameter> outputURLParameters = new LinkedList<OutputURLParameter>();
        for (Node node : this.getNodes()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            outputURLParameters.addAll(configurator.getOutputURLParameters());
        }
        return Collections.unmodifiableList(outputURLParameters);
    }

    @Override
    public Set<FileURLValue> getOutputURLs() {
        HashSet<FileURLValue> outputFiles = new HashSet<FileURLValue>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<FileURLValue> currentOutputFiles = configurator.getOutputURLs();
            outputFiles.addAll(currentOutputFiles);
        }
        return Collections.unmodifiableSet(outputFiles);
    }

    @Override
    public String getParameterLabel(String encodedParameterName) throws ParameterNotFoundException {
        Integer nodeId = this.getNodeIdFromEncodedParameterName(encodedParameterName);
        if (nodeId == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        Node node = this.nodesById.get(nodeId);
        if (node == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        String realParameterName = this.getRealParameterNameFromEncodedParameterName(encodedParameterName);
        if (realParameterName == null) {
            return null;
        }
        return node.getConfigurator().getParameterLabel(realParameterName);
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> allParameterNames = new HashSet<String>();
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Set<String> thisNodeParameterNames = configurator.getParameterNames();
            for (String parameterName : thisNodeParameterNames) {
                allParameterNames.add(node.getId() + "." + parameterName);
            }
        }
        return Collections.unmodifiableSet(allParameterNames);
    }

    @Override
    public String getParameterType(String encodedParameterName) throws ParameterNotFoundException {
        Integer nodeId = this.getNodeIdFromEncodedParameterName(encodedParameterName);
        if (nodeId == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        Node node = this.nodesById.get(nodeId);
        if (node == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        String realParameterName = this.getRealParameterNameFromEncodedParameterName(encodedParameterName);
        if (realParameterName == null) {
            return null;
        }
        return node.getConfigurator().getParameterType(realParameterName);
    }

    @Override
    public String getParameterValue(String encodedParameterName) throws ParameterNotFoundException {
        Integer nodeId = this.getNodeIdFromEncodedParameterName(encodedParameterName);
        if (nodeId == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        Node node = this.nodesById.get(nodeId);
        if (node == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        String realParameterName = this.getRealParameterNameFromEncodedParameterName(encodedParameterName);
        if (realParameterName == null) {
            return null;
        }
        return node.getConfigurator().getParameterValue(realParameterName);
    }

    @Override
    public Set<String> getPlatforms() {
        HashSet<String> platforms = new HashSet<String>();
        if (!this.nodesById.isEmpty()) {
            Iterator<Node> nodeIterator = this.nodesById.values().iterator();
            Node node = nodeIterator.next();
            AlgorithmConfigurator configurator = node.getConfigurator();
            platforms.addAll(configurator.getPlatforms());
            while (nodeIterator.hasNext()) {
                node = nodeIterator.next();
                configurator = node.getConfigurator();
                platforms.retainAll(configurator.getPlatforms());
            }
        }
        return Collections.unmodifiableSet(platforms);
    }

    @Override
    public void importValues(Map<Object, Object> values) throws ParseException {
        for (Node node : this.nodesById.values()) {
            Map nodeValues = (Map)values.get(node.getId());
            if (nodeValues == null) continue;
            node.getConfigurator().importValues(nodeValues);
        }
    }

    @Override
    public boolean isEnabled() {
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            if (configurator == null || !configurator.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSetDefaultValues() {
        for (Node node : this.nodesById.values()) {
            if (node.getConfigurator().isSetDefaultValues()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CommandScript[] makeCommandLineAsScript(CommandLineContext context) {
        if (this.canBeRunAsSimpleCommand()) {
            String simpleCommandLine = this.makeSimpleCommandLine(context);
            Node node = this.nodesById.values().iterator().next();
            CommandScript simpleCommandScript = new CommandScript(context, simpleCommandLine, CommandScript.makeFileName(String.valueOf(node.getId())));
            return new CommandScript[]{simpleCommandScript};
        }
        FlowCommandLineContext flowContext = (FlowCommandLineContext)context;
        Map<Integer, String> commands = this.makeCommands(true, flowContext);
        ArrayList<CommandScript> scripts = new ArrayList<CommandScript>();
        HashMap<Integer, String> scriptCommands = new HashMap<Integer, String>();
        for (Map.Entry<Integer, String> command : commands.entrySet()) {
            CommandLineContext nodeContext = flowContext.getFlowNodeContext(command.getKey());
            CommandScript script = new CommandScript(nodeContext, command.getValue(), CommandScript.makeFileName(String.valueOf(command.getKey())));
            scripts.add(script);
            scriptCommands.put(command.getKey(), script.makeCommandLine());
        }
        String flowCommandLine = this.makeFlowCommandLine(flowContext, scriptCommands);
        scripts.add(0, new CommandScript(flowContext, flowCommandLine));
        return scripts.toArray(new CommandScript[scripts.size()]);
    }

    private String makeSimpleCommandLine(CommandLineContext context) {
        if (this.nodesById.size() != 1) {
            return null;
        }
        Collection<Node> values = this.nodesById.values();
        Iterator<Node> nodeIterator = values.iterator();
        Node node = nodeIterator.next();
        AlgorithmConfigurator configurator = node.getConfigurator();
        return configurator.makeCommandLine(context);
    }

    public boolean canBeRunAsSimpleCommand() {
        return this.nodesById.size() <= 1;
    }

    @Override
    public String makeCommandLine(CommandLineContext context) {
        if (this.canBeRunAsSimpleCommand()) {
            return this.makeSimpleCommandLine(context);
        }
        FlowCommandLineContext flowContext = (FlowCommandLineContext)context;
        Map<Integer, String> commands = this.makeCommands(false, flowContext);
        return this.makeFlowCommandLine(flowContext, commands);
    }

    protected String makeEnvironmentVariablesDeclaration(FlowCommandLineContext context) {
        CommandLineBuilder commandLineBuilder = new CommandLineBuilder(context.isScript());
        if (this.hasExitCode()) {
            String flowErrorNodeLog = FileUtils.joinPath((char)context.getFileSeparator(), (String[])new String[]{context.getProjectRootDirectory(), context.getProjectDirectory(), this.getGuiltyNodeLog().getPath()});
            commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.FLOW_GUILTY_NODE_ID_LOG, flowErrorNodeLog);
        }
        String sandboxDir = FileUtils.joinPath((char)context.getFileSeparator(), (String[])new String[]{context.getSandboxRootDirectory(), context.getSandboxDirectory()});
        commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.FLOW_SANDBOX_DIR, sandboxDir);
        return commandLineBuilder.toString();
    }

    protected String makeFlowCommandLine(FlowCommandLineContext context, Map<Integer, String> commands) {
        Map<Integer, Map<String, String>> fromPipes = context.getFromPipes();
        Map<Integer, Map<String, String>> toPipes = context.getToPipes();
        Collection<String> tees = this.getTees(fromPipes, toPipes, context.isScript());
        CommandLineBuilder builder = new CommandLineBuilder(context.isScript());
        builder.append(this.makeEnvironmentVariablesDeclaration(context));
        builder.append("/bin/ksh").append(" ./flowmonitor ");
        builder.append(QUOTE);
        for (Map<String, String> pipes : fromPipes.values()) {
            for (String pipe : pipes.values()) {
                builder.append(pipe).append(" ");
            }
        }
        for (Map<String, String> pipes : toPipes.values()) {
            for (String pipe : pipes.values()) {
                builder.append(pipe).append(" ");
            }
        }
        builder.append(QUOTE);
        builder.append(" ").append(QUOTE);
        for (int i = 0; i < tees.size(); ++i) {
            builder.append(String.valueOf(-(i + 1))).append(" ");
        }
        for (Node node : this.nodesById.values()) {
            builder.append(String.valueOf(node.getId())).append(" ");
        }
        builder.append(QUOTE);
        for (String tee : tees) {
            builder.append(" ").append(QUOTE).append(tee).append(QUOTE);
        }
        for (String cmd : commands.values()) {
            builder.append(" ").append(QUOTE).append(cmd).append(QUOTE);
        }
        builder.appendEmptyLine();
        String cmd = builder.toString();
        if (!context.isScript()) {
            cmd = CommandLineBuilder.escapeReferenceChar(cmd);
        }
        return cmd;
    }

    @Override
    public void resetValues() {
        for (Node node : this.nodesById.values()) {
            node.getConfigurator().resetValues();
        }
    }

    @Override
    public boolean setDefaultInputFile(FileURLValue inputFile) {
        return false;
    }

    @Override
    public boolean setEnabled(boolean isEnabled) {
        if (this.isEnabled() == isEnabled) {
            return false;
        }
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            if (configurator == null) continue;
            configurator.setEnabled(isEnabled);
        }
        this.fireWasSetEnabled();
        return true;
    }

    @Override
    public void setParameterValue(String encodedParameterName, String parameterValue) throws ParameterNotFoundException, ParseException {
        NodeParameter flowNodeParameter;
        FlowNode flowNode;
        Integer nodeId = this.getNodeIdFromEncodedParameterName(encodedParameterName);
        if (nodeId == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        Node node = this.nodesById.get(nodeId);
        if (node == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        String realParameterName = this.getRealParameterNameFromEncodedParameterName(encodedParameterName);
        if (realParameterName == null) {
            throw new ParameterNotFoundException(encodedParameterName);
        }
        AlgorithmConfigurator configurator = node.getConfigurator();
        configurator.setParameterValue(realParameterName, parameterValue);
        Flow flx = this.getFlow();
        if (null != flx && null != (flowNode = flx.getNode(node.getId())) && null != (flowNodeParameter = flowNode.getParameter(realParameterName))) {
            flowNodeParameter.setValue(parameterValue);
        }
    }

    @Override
    public void setStandardOutputFile(FileURLValue standardOutputFile) {
        this.flow.setStandardOutputFile(standardOutputFile);
    }

    @Override
    public Set<FileURLValue> getStandardOutputFiles() {
        return this.flow.getStandardOutputFiles();
    }

    @Override
    public void setExitCodeLogFile(FileURLValue exitCodeLogFile) {
        this.flow.setExitCodeLogFile(exitCodeLogFile);
    }

    @Override
    public Set<FileURLValue> getExitCodeLogFiles() {
        return this.flow.getExitCodeLogFiles();
    }

    @Override
    public boolean hasExitCode() {
        return this.flow.hasExitCode();
    }

    @Override
    protected String getCurrentParameterFileVersion() {
        return "1.0";
    }

    private Integer getNodeIdFromEncodedParameterName(String encodedParameterName) {
        Pattern pattern = Pattern.compile(PARAMETER_NAME_REGEX);
        Matcher matcher = pattern.matcher(encodedParameterName);
        if (!matcher.matches()) {
            return null;
        }
        String nodeIdAsText = matcher.group(1);
        return Integer.parseInt(nodeIdAsText);
    }

    private String getRealParameterNameFromEncodedParameterName(String encodedParameterName) {
        Pattern pattern = Pattern.compile(PARAMETER_NAME_REGEX);
        Matcher matcher = pattern.matcher(encodedParameterName);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(2);
    }

    private Collection<String> getTees(Map<Integer, Map<String, String>> fromPipes, Map<Integer, Map<String, String>> toPipes, boolean asScript) {
        LinkedList<String> tees = new LinkedList<String>();
        Collection<Node> nodes = this.nodesById.values();
        for (Node node : nodes) {
            for (Output output : node.getOutputs()) {
                Collection<Input> inputs;
                if (output.isDir() || (inputs = output.getInputs()).isEmpty()) continue;
                CommandLineBuilder teeCommand = new CommandLineBuilder(asScript);
                teeCommand.append("tee ");
                for (Input input : inputs) {
                    int nodeId = input.getNodeId();
                    String parameterName = input.getParameterName();
                    String toPipe = toPipes.get(nodeId).get(parameterName);
                    teeCommand.append(toPipe).append(" ");
                }
                int nodeId = output.getNodeId();
                String parameterName = output.getParameterName();
                String fromPipe = fromPipes.get(nodeId).get(parameterName);
                teeCommand.append("< ").append(fromPipe).discardOutput();
                tees.add(teeCommand.toString());
            }
        }
        return tees;
    }

    private String makeNodeCommand(boolean asScript, Integer nodeId, CommandLineContext context, Map<String, String> fromPipes, Map<String, String> toPipes, Map<String, String> linkDirectories) {
        Node node = this.nodesById.get(nodeId);
        AlgorithmConfigurator configurator = node.getConfigurator();
        HashMap<String, String> parameterValuesByName = new HashMap<String, String>();
        for (String parameterName : configurator.getParameterNames()) {
            try {
                String parameterValue = configurator.getParameterValue(parameterName);
                parameterValuesByName.put(parameterName, parameterValue);
            }
            catch (ParameterNotFoundException e) {
                throw new BugException(e);
            }
        }
        if (toPipes != null) {
            parameterValuesByName.putAll(toPipes);
        }
        if (fromPipes != null) {
            parameterValuesByName.putAll(fromPipes);
        }
        if (linkDirectories != null) {
            parameterValuesByName.putAll(linkDirectories);
        }
        try {
            configurator.setParameterValuesByName(parameterValuesByName);
        }
        catch (ParseException e) {
            throw new BugException(e);
        }
        catch (ParameterNotFoundException e) {
            throw new BugException(e);
        }
        String command = configurator.makeCommandLine(context);
        return command;
    }

    private Map<Integer, String> makeCommands(boolean asScript, FlowCommandLineContext flowContext) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        Map<Integer, Map<String, String>> linkDirectories = flowContext.getLinkDirectories();
        for (Integer nodeId : this.nodesById.keySet()) {
            String command = this.makeNodeCommand(asScript, nodeId, flowContext.getFlowNodeContext(nodeId), flowContext.getToPipes().get(nodeId), flowContext.getFromPipes().get(nodeId), linkDirectories.get(nodeId));
            if (command == null) continue;
            commands.put(nodeId, command);
        }
        return commands;
    }

    private void setFlow(Flow flow) {
        if (flow == null) {
            throw new IllegalArgumentException("O par\u00e2metro flow est\u00e1 nulo.");
        }
        this.flow = flow;
        this.canBeExecuted = false;
        Map<Integer, Node> nodesMap = this.createNodesMap(flow);
        if (nodesMap != null) {
            this.nodesById = nodesMap;
            this.canBeExecuted = true;
        } else {
            this.nodesById = Collections.emptyMap();
        }
    }

    @Override
    public void setCommandDescription(String commandDescription) {
        this.flow.setDescription(commandDescription);
    }

    @Override
    public String getCommandDescription() {
        return this.flow.getDescription();
    }

    public boolean canBeExecuted() {
        return this.canBeExecuted;
    }

    protected Map<Integer, Node> createNodesMap(Flow flx) {
        HashMap<Integer, Node> nodesMap = new HashMap<Integer, Node>();
        if (this.isConfigured(flx)) {
            this.addNodes(nodesMap, flx);
            if (this.addLinks(nodesMap, flx)) {
                return nodesMap;
            }
        }
        return null;
    }

    protected boolean isConfigured(Flow flx) {
        for (FlowNode flowNode : flx.getNodes()) {
            AlgorithmConfigurator algorithmConfigurator = flowNode.getAlgorithmConfigurator();
            if (algorithmConfigurator != null) continue;
            return false;
        }
        return true;
    }

    protected void addNodes(Map<Integer, Node> nodesMap, Flow flx) {
        for (FlowNode flowNode : flx.getNodes()) {
            if (flowNode.isBypassed()) continue;
            AlgorithmConfigurator algorithmConfigurator = flowNode.getAlgorithmConfigurator();
            Node node = new Node(flowNode.getId(), algorithmConfigurator);
            nodesMap.put(node.getId(), node);
        }
    }

    protected boolean addLinks(Map<Integer, Node> nodesMap, Flow flx) {
        ArrayList<FlowLink> pendingLinks = new ArrayList<FlowLink>();
        ArrayList<FlowLink> bypassedLinks = new ArrayList<FlowLink>();
        for (FlowLink flowLink : flx.getLinks()) {
            LinkParameter inputLinkParameter = flowLink.getInput();
            int inputNodeId = inputLinkParameter.getNodeId();
            Node inputNode = nodesMap.get(inputNodeId);
            if (inputNode == null) {
                bypassedLinks.add(flowLink);
                continue;
            }
            LinkParameter outputLinkParameter = flowLink.getOutput();
            int outputNodeId = outputLinkParameter.getNodeId();
            Node outputNode = nodesMap.get(outputNodeId);
            if (outputNode == null) {
                pendingLinks.add(flowLink);
                continue;
            }
            this.addLink(outputNode, outputLinkParameter, inputNode, inputLinkParameter);
        }
        if (pendingLinks.size() > 0) {
            return this.addPendingLinks(nodesMap, pendingLinks, bypassedLinks);
        }
        return true;
    }

    protected void addLink(Node outputNode, LinkParameter outputLinkParameter, Node inputNode, LinkParameter inputLinkParameter) {
        Input input = new Input(inputLinkParameter.getNodeId(), inputLinkParameter.getName());
        Output output = outputNode.getOutput(outputLinkParameter.getName());
        if (output != null) {
            output.addInput(input);
            AlgorithmConfigurator outputConfigurator = outputNode.getConfigurator();
            List<OutputFileParameter> outputFileParameters = outputConfigurator.getOutputFileParameters();
            for (OutputFileParameter parameter : outputFileParameters) {
                if (!parameter.getName().equals(output.getParameterName())) continue;
                parameter.setHasLink(true);
                break;
            }
            List<OutputURLParameter> outputURLParameters = outputConfigurator.getOutputURLParameters();
            for (OutputURLParameter parameter : outputURLParameters) {
                if (!parameter.getName().equals(output.getParameterName())) continue;
                parameter.setHasLink(true);
                break;
            }
            AlgorithmConfigurator inputConfigurator = inputNode.getConfigurator();
            List<InputFileParameter> inputFileParameters = inputConfigurator.getInputFileParameters();
            for (InputFileParameter parameter : inputFileParameters) {
                if (!parameter.getName().equals(input.getParameterName())) continue;
                parameter.setHasLink(true);
                break;
            }
            List<InputURLParameter> inputURLParameters = inputConfigurator.getInputURLParameters();
            for (InputURLParameter parameter : inputURLParameters) {
                if (!parameter.getName().equals(input.getParameterName())) continue;
                parameter.setHasLink(true);
                break;
            }
        }
    }

    protected boolean addPendingLinks(Map<Integer, Node> nodesMap, List<FlowLink> pendingLinks, List<FlowLink> bypassedLinks) {
        Map<LinkParameter, List<FlowLink>> pendingLinksByOutput = this.groupPendingLinksByOutput(pendingLinks);
        HashMap<FlowLink, FlowLink> linkMatches = new HashMap<FlowLink, FlowLink>();
        for (List<FlowLink> pendingInputLinks : pendingLinksByOutput.values()) {
            FlowLink pendingInputLink = pendingInputLinks.get(0);
            FlowLink matchingLink = this.getMatchingLink(bypassedLinks, pendingInputLink);
            if (matchingLink == null) continue;
            for (FlowLink link : pendingInputLinks) {
                linkMatches.put(link, matchingLink);
            }
        }
        if (this.areAllPendingLinksMatched(pendingLinks, linkMatches) && this.areAllBypassedLinksMatched(nodesMap, bypassedLinks, linkMatches)) {
            for (FlowLink pendingLink : linkMatches.keySet()) {
                this.addPendingLink(nodesMap, pendingLink, (FlowLink)linkMatches.get(pendingLink));
            }
            return true;
        }
        return false;
    }

    private boolean areAllPendingLinksMatched(List<FlowLink> pendingLinks, Map<FlowLink, FlowLink> linkMatches) {
        return linkMatches.keySet().size() == pendingLinks.size();
    }

    protected boolean areAllBypassedLinksMatched(Map<Integer, Node> nodesMap, List<FlowLink> bypassedLinks, Map<FlowLink, FlowLink> linkMatches) {
        HashSet<FlowLink> matchingLinksSet = new HashSet<FlowLink>();
        matchingLinksSet.addAll(linkMatches.values());
        return this.countBypassedLinks(bypassedLinks, nodesMap) == matchingLinksSet.size();
    }

    protected int countBypassedLinks(List<FlowLink> bypassedLinks, Map<Integer, Node> nodesMap) {
        ArrayList<FlowLink> links = new ArrayList<FlowLink>();
        for (FlowLink flowLink : bypassedLinks) {
            Node inputNode = nodesMap.get(flowLink.getInput().getNodeId());
            Node outputNode = nodesMap.get(flowLink.getOutput().getNodeId());
            if (inputNode == null && outputNode == null) continue;
            links.add(flowLink);
        }
        return links.size();
    }

    protected void addPendingLink(Map<Integer, Node> nodesMap, FlowLink pendingLink, FlowLink matchingLink) {
        LinkParameter inputParam = pendingLink.getInput();
        LinkParameter outputParam = matchingLink.getOutput();
        int newOutputNodeId = outputParam.getNodeId();
        Node outputNode = nodesMap.get(newOutputNodeId);
        int newInputNodeId = inputParam.getNodeId();
        Node inputNode = nodesMap.get(newInputNodeId);
        this.addLink(outputNode, outputParam, inputNode, inputParam);
    }

    protected Map<LinkParameter, List<FlowLink>> groupPendingLinksByOutput(List<FlowLink> pendingLinks) {
        HashMap<LinkParameter, List<FlowLink>> pendingLinksByOutput = new HashMap<LinkParameter, List<FlowLink>>();
        for (FlowLink link : pendingLinks) {
            ArrayList<FlowLink> linkList = (ArrayList<FlowLink>)pendingLinksByOutput.get(link.getOutput());
            if (linkList == null) {
                linkList = new ArrayList<FlowLink>();
                pendingLinksByOutput.put(link.getOutput(), linkList);
            }
            linkList.add(link);
        }
        return pendingLinksByOutput;
    }

    protected FlowLink getMatchingLink(List<FlowLink> bypassedLinks, FlowLink pendingInputLink) {
        List<FlowLink> matchingLinks = this.getMatchingLinksByType(pendingInputLink, bypassedLinks);
        if (matchingLinks != null) {
            if (matchingLinks.size() == 1) {
                return matchingLinks.get(0);
            }
            if (matchingLinks.size() > 1 && (matchingLinks = this.getMatchingLinksByName(pendingInputLink, matchingLinks)) != null && matchingLinks.size() == 1) {
                return matchingLinks.get(0);
            }
        }
        return null;
    }

    protected List<FlowLink> getMatchingLinksByType(FlowLink pendingLink, List<FlowLink> candidateLinks) {
        ArrayList<FlowLink> matchingLinks = new ArrayList<FlowLink>();
        for (FlowLink candidateLink : candidateLinks) {
            if (pendingLink.getOutput().getNodeId() != candidateLink.getInput().getNodeId()) continue;
            matchingLinks.addAll(this.getMatchingLinksByTypeRecursively(pendingLink, candidateLink, candidateLinks));
        }
        if (matchingLinks.size() > 0) {
            return matchingLinks;
        }
        return null;
    }

    protected List<FlowLink> getMatchingLinksByTypeRecursively(FlowLink pendingLink, FlowLink candidateLink, List<FlowLink> candidateLinks) {
        ArrayList<FlowLink> matchingLinks = new ArrayList<FlowLink>();
        FlowNode parentNode = this.flow.getNode(candidateLink.getOutput().getNodeId());
        if (!parentNode.isBypassed()) {
            if (this.getInputParamType(pendingLink).equals(this.getInputParamType(candidateLink))) {
                matchingLinks.add(candidateLink);
            }
        } else {
            for (FlowLink link : candidateLinks) {
                if (link.getInput().getNodeId() != parentNode.getId()) continue;
                matchingLinks.addAll(this.getMatchingLinksByTypeRecursively(pendingLink, link, candidateLinks));
            }
        }
        return matchingLinks;
    }

    protected List<FlowLink> getMatchingLinksByName(FlowLink pendingLink, List<FlowLink> candidateLinks) {
        ArrayList<FlowLink> matchingLinks = new ArrayList<FlowLink>();
        for (FlowLink candidateLink : candidateLinks) {
            String candidateLinkName;
            String linkName;
            if (pendingLink.getOutput().getNodeId() != candidateLink.getInput().getNodeId() || !(linkName = pendingLink.getInput().getName()).equals(candidateLinkName = candidateLink.getInput().getName())) continue;
            matchingLinks.add(candidateLink);
        }
        if (matchingLinks.size() > 0) {
            return matchingLinks;
        }
        return null;
    }

    protected String getInputParamType(FlowLink link) {
        LinkParameter input = link.getInput();
        FlowNode node = this.flow.getNode(input.getNodeId());
        String inputName = input.getName();
        NodeParameter inputParameter = node.getParameter(inputName);
        return inputParameter.getType();
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return super.toString();
    }

    @Override
    public Validation validate(ValidationContext context) throws RemoteException {
        for (Node node : this.nodesById.values()) {
            AlgorithmConfigurator configurator = node.getConfigurator();
            Validation result = configurator.validate(context);
            if (result.isWellSucceded()) continue;
            AlgorithmInfo info = configurator.getAlgorithmVersion().getInfo();
            return new FlowNodeValidationResult(result, info);
        }
        return new ValidationSuccess();
    }
}

