/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.Column;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.RowValue;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parameters.validators.BooleanParameterValidator;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.parameters.validators.EnumerationParameterValidator;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.parameters.validators.TextParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class TableParameterValidator
extends SimpleParameterValidator<List<RowValue>> {
    private List<SimpleParameterValidator<?>> columnValidators;
    private int columnIndex;
    private int rowIndex;

    public TableParameterValidator(boolean optional, List<Column<?>> columns) {
        super(optional);
        this.columnValidators = new ArrayList(columns.size());
        for (Column<?> column : columns) {
            if (column instanceof BooleanColumn) {
                this.columnValidators.add(new BooleanParameterValidator());
                continue;
            }
            if (column instanceof DoubleColumn) {
                DoubleColumn doubleColumn = (DoubleColumn)column;
                this.columnValidators.add(new DoubleParameterValidator(doubleColumn.isOptional(), doubleColumn.getMaximum(), doubleColumn.isMaximumIncluded(), doubleColumn.getMinimum(), doubleColumn.isMinimumIncluded()));
                continue;
            }
            if (column instanceof IntegerColumn) {
                IntegerColumn integerColumn = (IntegerColumn)column;
                this.columnValidators.add(new IntegerParameterValidator(integerColumn.isOptional(), integerColumn.getMaximum(), integerColumn.getMinimum()));
                continue;
            }
            if (column instanceof TextColumn) {
                TextColumn textColumn = (TextColumn)column;
                this.columnValidators.add(new TextParameterValidator(textColumn.isOptional(), textColumn.getMaxCharacters()));
                continue;
            }
            if (column instanceof EnumerationColumn) {
                this.columnValidators.add(new EnumerationParameterValidator(column.isOptional()));
                continue;
            }
            throw new IllegalStateException(String.format("Tipo inesperado para a coluna %s.\nTipo encontrado: %s.", column.getId(), column.getClass()));
        }
    }

    @Override
    public void setMode(ValidationMode mode) {
        for (SimpleParameterValidator<?> validator : this.columnValidators) {
            validator.setMode(mode);
        }
        super.setMode(mode);
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, List<RowValue> value, ValidationContext context) throws RemoteException {
        if (!parameter.isEnabled() || !parameter.isVisible()) {
            return new ValidationSuccess();
        }
        TableParameter tableParameter = (TableParameter)parameter;
        if (tableParameter.getRowCount() == 0) {
            if (this.isOptional() || this.getMode().equals((Object)ValidationMode.ALLOW_EMPY_VALUES)) {
                return new ValidationSuccess();
            }
            LocalizedMessage message = new LocalizedMessage(TableParameterValidator.class, "empty_value", new Object[]{parameter.getLabel()});
            return new ValidationError(message);
        }
        for (int i = 0; i < tableParameter.getRowCount(); ++i) {
            this.rowIndex = i;
            List<Column<?>> columns = tableParameter.getColumns();
            for (int j = 0; j < columns.size(); ++j) {
                this.columnIndex = j;
                Object itemValue = tableParameter.getItemValue(i, j);
                SimpleParameterValidator<List<RowValue>> validator = this.columnValidators.get(j);
                Validation result = validator.validateValue(tableParameter, (List<RowValue>)itemValue, context);
                if (result.isWellSucceded()) continue;
                return result;
            }
        }
        return new ValidationSuccess();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }
}

