/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.ValidationExpression;
import csbase.logic.algorithms.parsers.XmlParser;

public class ValidationExpressionParser {
    static final String EXPRESSION_ELEMENT = "expressao";
    private static final String EXPRESSION_ELEMENT_ERROR_ATTRIBUTE = "erro";

    public void loadExpression(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        ValidationExpression expression;
        String errorMessage = parser.extractAttributeValue(EXPRESSION_ELEMENT_ERROR_ATTRIBUTE);
        String expressionText = parser.getElementValue(null);
        if (expressionText == null) {
            throw new ParseException("O texto com a express\u00e3o do elemento {0} n\u00e3o foi encontrado.", EXPRESSION_ELEMENT);
        }
        parser.checkAttributes();
        parser.checkChildElements();
        try {
            expression = new ValidationExpression(configurator, expressionText, errorMessage);
        }
        catch (FormulaCreationException e) {
            throw new ParseException(e, e.getLocalizedMessage(), new Object[0]);
        }
        if (!configurator.addExpression(expression)) {
            throw new ParseException("A express\u00e3o {0} est\u00e1 duplicada no algoritmo {1}.", expression, configurator);
        }
    }
}

