/**
 * $Id: ProjectFileTypeInfo.java 115732 2011-02-22 22:57:02Z cassino $
 */
package csbase.logic;

import java.io.Serializable;
import java.util.List;

/**
 * A classe <code>ProjectFileTypeInfo</code> representa os dados de um tipo de
 * arquivo.
 * 
 * @author Taciana
 * @version $Revision: 115732 $
 */
public class ProjectFileTypeInfo implements Serializable {
  /**
   * Cdigo do tipo
   */
  public String typeCode;
  /**
   * Descrio do tipo
   */
  public String description;
  /**
   * MimeType do tipo
   */
  public String mimeType;
  /**
   * cone de um arquivo regular
   */
  public byte[] baseIcon;
  /**
   * cone de um arquivo em construo
   */
  public byte[] ucIcon;
  /**
   * cone de um arquivo recortado
   */
  public byte[] cutIcon;
  /**
   * Extensoes que um arquivo pode ter
   */
  public List<String> extensions;

  /**
   * Cria um FileTypeInfo.
   * 
   * @param typeCode .
   * @param description .
   * @param mimeType .
   * @param baseIcon .
   * @param ucIcon .
   * @param cutIcon .
   * @param extensions .
   */
  public ProjectFileTypeInfo(String typeCode, String description,
    String mimeType, byte[] baseIcon, byte[] ucIcon, byte[] cutIcon,
    List<String> extensions) {
    this.typeCode = typeCode;
    this.description = description;
    this.mimeType = mimeType;
    this.baseIcon = baseIcon;
    this.ucIcon = ucIcon;
    this.cutIcon = cutIcon;
    this.extensions = extensions;
  }
}
