/*
 * RemoteObserver.java
 *
 * $Author: cassino $
 * $Revision: 116055 $  - $Date: 2011-03-04 15:15:45 -0300 (Fri, 04 Mar 2011) $
 */
package csbase.remote;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * A interface <code>RemoteObserver</code> representa um objeto que precisa ser
 * informado de mudanas em um objeto remoto. Um objeto observado precisa
 * implementar a interface {@link csbase.remote.RemoteObservable
 * RemoteObsevable}.
 * 
 * @author Maria Julia Lima
 * @version $Revision: 116055 $
 */
public interface RemoteObserver extends Remote {
  /**
   * Esse mtodo  chamado sempre que alguma alterao ocorre em um objeto
   * observado.
   * 
   * @param event O evento que descreve a mudana ocorrida.
   * @throws RemoteException Em caso de falha.
   */
  void update(RemoteEvent event) throws RemoteException;

  /**
   * Esse mtodo  chamado sempre que alteraes ocorrem em um objeto observado.
   * 
   * @param events Os eventos que descrevem as mudanas ocorridas.
   * @throws RemoteException Em caso de falha.
   */
  void update(RemoteEvent[] events) throws RemoteException;

  /**
   * Registra no servidor um observador.
   * 
   * @throws RemoteException Em caso de falha.
   */
  void install() throws RemoteException;

  /**
   * Remove do servidor o registro desse observador.
   * 
   * @throws RemoteException Em caso de falha.
   */
  void uninstall() throws RemoteException;
}
