package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parsers.AbstractTextParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica para {@link TextColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class TextColumnFactory extends AbstractTableColumnFactory {

  /**
   * <p>
   * O elemento {@value #ELEMENT_NAME}: descreve uma {@link TextColumn coluna do
   * tipo texto} de um {@link TableParameter parmetro do tipo tabela} .
   * </p>
   */
  private static final String ELEMENT_NAME = "coluna_de_texto";

  /**
   * Cria a fbrica.
   */
  public TextColumnFactory() {
    super(ELEMENT_NAME);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setCellValue(XmlParser parser, String parameterName,
    TableColumn<?> column, int rowIndex, String valueAttributeName) {
    TextColumn textColumn = (TextColumn) column;
    String cellValue = parser.extractAttributeValue(valueAttributeName, null);
    textColumn.addDefaultValue(rowIndex, cellValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected TextColumn createColumn(XmlParser parser, String parameterName,
    String label, String id, boolean isOptional, boolean isEditable,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    String defaultValue = parser.extractAttributeValue(
      COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null);
    Integer maxCharacters = parser.extractAttributeValueAsInteger(
      AbstractTextParameterParser.TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE,
      null, null,
      AbstractTextParameterParser.TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE);
    parser.checkAttributes();
    parser.checkChildElements();
    return new TextColumn(id, label, defaultValue, isOptional, isEditable,
      maxCharacters);
  }
}
