/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.InputURLListParameter;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import csbase.logic.algorithms.parameters.ValidationExpression;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import tecgraf.javautils.core.io.FileUtils;

public final class SimpleAlgorithmConfigurator
extends AlgorithmConfigurator {
    private String commandBinaryName;
    private String defaultInputFileParameterName;
    private Set<ValidationExpression> expressions = new HashSet<ValidationExpression>();
    private List<ParameterGroup> groups = new LinkedList<ParameterGroup>();
    private Set<HiddenParameter> hiddenParameters = new HashSet<HiddenParameter>();
    private boolean isEnabled = true;
    private boolean showOutput;
    private String shell;
    private Set<Trigger<?>> triggers = new HashSet();

    public SimpleAlgorithmConfigurator(AlgorithmVersionInfo algorithmVersion, String description, ExecutionType executionType, ExecutionLocation executionLocation, String abbreviation, boolean provideId, String command, String shell, String defaultInputFileParameterName, boolean showOutput, String commandLinePattern) {
        super(AlgorithmConfigurator.ConfiguratorType.SIMPLE, algorithmVersion, description, executionType, executionLocation, abbreviation, provideId, commandLinePattern);
        this.shell = shell;
        this.defaultInputFileParameterName = defaultInputFileParameterName;
        this.showOutput = showOutput;
        this.setCommandBinaryName(command);
    }

    public boolean addExpression(ValidationExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("O par\u00e2metro expression est\u00e1 nulo.");
        }
        return this.expressions.add(expression);
    }

    public boolean addGroup(ParameterGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("O par\u00e2metro group est\u00e1 nulo.");
        }
        if (this.groups.contains(group)) {
            return false;
        }
        this.groups.add(group);
        for (SimpleParameter<?> parameter : group.getSimpleParameters()) {
            this.addParameterListeners(parameter);
        }
        return true;
    }

    private <T> void addParameterListeners(SimpleParameter<T> parameter) {
        parameter.addSimpleParameterListener(new SimpleParameterListener<T>(){

            @Override
            public void capabilityWasChanged(SimpleParameter<T> param) {
                SimpleAlgorithmConfigurator.this.fireParameterWasSetEnabled(param.getName(), param.isEnabled());
            }

            @Override
            public void defaultValueWasChanged(SimpleParameter<T> param) {
            }

            @Override
            public void labelWasChanged(SimpleParameter<T> param) {
                SimpleAlgorithmConfigurator.this.fireParameterLabelWasChanged(param.getName(), param.getLabel());
            }

            @Override
            public void valueWasChanged(SimpleParameter<T> param) {
                SimpleAlgorithmConfigurator.this.fireParameterValueWasChanged(param.getName(), param.getValue());
            }

            @Override
            public void visibilityWasChanged(SimpleParameter<T> param) {
                SimpleAlgorithmConfigurator.this.fireParameterWasSetVisible(param.getName(), param.isVisible());
            }
        });
        parameter.addSimpleParameterListener(new SimpleParameterListener<T>(){

            @Override
            public void capabilityWasChanged(SimpleParameter<T> param) {
            }

            @Override
            public void defaultValueWasChanged(SimpleParameter<T> param) {
            }

            @Override
            public void labelWasChanged(SimpleParameter<T> param) {
            }

            @Override
            public void valueWasChanged(SimpleParameter<T> param) {
                SimpleAlgorithmConfigurator.this.updateTriggers();
            }

            @Override
            public void visibilityWasChanged(SimpleParameter<T> param) {
            }
        });
    }

    public boolean addHiddenParameter(HiddenParameter hiddenParameter) {
        if (hiddenParameter == null) {
            throw new IllegalArgumentException("O par\u00e2metro hiddenParameter est\u00e1 nulo.");
        }
        return this.hiddenParameters.add(hiddenParameter);
    }

    public boolean addTrigger(Trigger<?> trigger) {
        if (trigger == null) {
            throw new IllegalArgumentException("O par\u00e2metro trigger est\u00e1 nulo.");
        }
        if (!this.triggers.add(trigger)) {
            return false;
        }
        for (Trigger<?> aTrigger : this.getTriggers()) {
            aTrigger.update(this);
        }
        return true;
    }

    @Override
    public Map<Object, Object> exportValues() {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        for (ParameterGroup group : this.getGroups()) {
            Map<String, Object> values = group.exportValue();
            for (String parameterKey : values.keySet()) {
                parameterValues.put(parameterKey, values.get(parameterKey));
            }
        }
        return Collections.unmodifiableMap(parameterValues);
    }

    @Override
    public Set<String[]> getBinaryDirectoriesAsArray(String platformId) {
        String[] binaryDirectory = this.getBinaryDirectoryAsArray(platformId);
        HashSet<String[]> binaryDirectories = new HashSet<String[]>();
        binaryDirectories.add(binaryDirectory);
        return binaryDirectories;
    }

    @Override
    public Set<String> getBinaryDirectories(String platformId, char fileSeparator) {
        String binaryDirectory = this.getBinaryDirectory(platformId, fileSeparator);
        TreeSet<String> binaryDirectories = new TreeSet<String>();
        binaryDirectories.add(binaryDirectory);
        return binaryDirectories;
    }

    public String getCommandBinaryName() {
        return this.commandBinaryName;
    }

    public String getDefaultInputFileParameterName() {
        return this.defaultInputFileParameterName;
    }

    @Override
    public Set<FileURLValue> getInputDirectories() {
        HashSet<FileURLValue> directories = new HashSet<FileURLValue>();
        for (FileParameter fileParameter : this.getInputFileParameters()) {
            FileURLValue file = (FileURLValue)fileParameter.getValue();
            if (file == null || !file.isDirectory()) continue;
            directories.add(file);
        }
        for (InputFileListParameter inputFileListParameter : this.getInputFileListParameters()) {
            List files = (List)inputFileListParameter.getValue();
            if (files == null) continue;
            for (FileURLValue file : files) {
                if (!file.isDirectory()) continue;
                directories.add(file);
            }
        }
        return Collections.unmodifiableSet(directories);
    }

    @Override
    public Set<FileURLValue> getOutputDirectories() {
        HashSet<FileURLValue> directories = new HashSet<FileURLValue>();
        for (FileParameter fileParameter : this.getOutputFileParameters()) {
            FileURLValue file = (FileURLValue)fileParameter.getValue();
            if (file == null || !file.isDirectory()) continue;
            directories.add(file);
        }
        for (OutputFileListParameter outputFileListParameter : this.getOutputFileListParameters()) {
            List files = (List)outputFileListParameter.getValue();
            if (files == null) continue;
            for (FileURLValue file : files) {
                if (!file.isDirectory()) continue;
                directories.add(file);
            }
        }
        return Collections.unmodifiableSet(directories);
    }

    public Set<ValidationExpression> getExpressions() {
        return Collections.unmodifiableSet(this.expressions);
    }

    public List<ParameterGroup> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public Set<HiddenParameter> getHiddenParameters() {
        return Collections.unmodifiableSet(this.hiddenParameters);
    }

    public List<InputFileListParameter> getInputFileListParameters() {
        LinkedList<InputFileListParameter> inputFileListParameters = new LinkedList<InputFileListParameter>();
        for (ParameterGroup group : this.getGroups()) {
            inputFileListParameters.addAll(group.getInputFileListParameters());
        }
        return Collections.unmodifiableList(inputFileListParameters);
    }

    public List<OutputFileListParameter> getOutputFileListParameters() {
        LinkedList<OutputFileListParameter> outputFileListParameters = new LinkedList<OutputFileListParameter>();
        for (ParameterGroup group : this.getGroups()) {
            outputFileListParameters.addAll(group.getOutputFileListParameters());
        }
        return Collections.unmodifiableList(outputFileListParameters);
    }

    public List<InputURLListParameter> getInputURLListParameters() {
        LinkedList<InputURLListParameter> inputURLListParameters = new LinkedList<InputURLListParameter>();
        for (ParameterGroup group : this.getGroups()) {
            inputURLListParameters.addAll(group.getInputURLListParameters());
        }
        return Collections.unmodifiableList(inputURLListParameters);
    }

    public List<OutputURLListParameter> getOutputURLListParameters() {
        LinkedList<OutputURLListParameter> outputURLListParameters = new LinkedList<OutputURLListParameter>();
        for (ParameterGroup group : this.getGroups()) {
            outputURLListParameters.addAll(group.getOutputURLListParameters());
        }
        return Collections.unmodifiableList(outputURLListParameters);
    }

    @Override
    public List<InputFileParameter> getInputFileParameters() {
        LinkedList<InputFileParameter> inputFileParameters = new LinkedList<InputFileParameter>();
        for (ParameterGroup group : this.getGroups()) {
            inputFileParameters.addAll(group.getInputFileParameters());
        }
        return Collections.unmodifiableList(inputFileParameters);
    }

    @Override
    public Set<FileURLValue> getInputFiles() {
        HashSet<FileURLValue> inputFiles = new HashSet<FileURLValue>();
        List<InputFileParameter> inputFileParameters = this.getInputFileParameters();
        for (InputFileParameter inputFileParameter : inputFileParameters) {
            FileURLValue file = (FileURLValue)inputFileParameter.getValue();
            if (file == null || !file.isRegularFile()) continue;
            inputFiles.add(file);
        }
        for (InputFileListParameter inputFileListParameter : this.getInputFileListParameters()) {
            List files = (List)inputFileListParameter.getValue();
            if (files == null) continue;
            for (FileURLValue file : files) {
                if (!file.isRegularFile()) continue;
                inputFiles.add(file);
            }
        }
        return Collections.unmodifiableSet(inputFiles);
    }

    @Override
    public List<OutputFileParameter> getOutputFileParameters() {
        LinkedList<OutputFileParameter> outputFileParameters = new LinkedList<OutputFileParameter>();
        for (ParameterGroup group : this.getGroups()) {
            outputFileParameters.addAll(group.getOutputFileParameters());
        }
        return Collections.unmodifiableList(outputFileParameters);
    }

    @Override
    public Set<FileURLValue> getOutputFiles() {
        HashSet<FileURLValue> outputFiles = new HashSet<FileURLValue>();
        List<OutputFileParameter> outputFileParameters = this.getOutputFileParameters();
        for (OutputFileParameter outputFileParameter : outputFileParameters) {
            FileURLValue file;
            if (!outputFileParameter.isVisible() && outputFileParameter.ignoreIfInvisible() || !outputFileParameter.isEnabled() && outputFileParameter.ignoreIfDisabled() || (file = (FileURLValue)outputFileParameter.getValue()) == null || !file.isRegularFile()) continue;
            outputFiles.add(file);
        }
        for (OutputFileListParameter outputFileListParameter : this.getOutputFileListParameters()) {
            List files;
            if (!outputFileListParameter.isVisible() && outputFileListParameter.ignoreIfInvisible() || !outputFileListParameter.isEnabled() && outputFileListParameter.ignoreIfDisabled() || (files = (List)outputFileListParameter.getValue()) == null) continue;
            for (FileURLValue file : files) {
                if (!file.isRegularFile()) continue;
                outputFiles.add(file);
            }
        }
        return Collections.unmodifiableSet(outputFiles);
    }

    @Override
    public List<InputURLParameter> getInputURLParameters() {
        LinkedList<InputURLParameter> inputURLParameters = new LinkedList<InputURLParameter>();
        for (ParameterGroup group : this.getGroups()) {
            inputURLParameters.addAll(group.getInputURLParameters());
        }
        return Collections.unmodifiableList(inputURLParameters);
    }

    @Override
    public Set<FileURLValue> getInputURLs() {
        HashSet<FileURLValue> inputURLs = new HashSet<FileURLValue>();
        List<InputURLParameter> inputURLParameters = this.getInputURLParameters();
        for (InputURLParameter inputURLParameter : inputURLParameters) {
            FileURLValue file = (FileURLValue)inputURLParameter.getValue();
            if (file == null || !file.isRegularFile()) continue;
            inputURLs.add(file);
        }
        for (InputURLListParameter inputURLListParameter : this.getInputURLListParameters()) {
            List urls = (List)inputURLListParameter.getValue();
            if (urls == null) continue;
            for (FileURLValue url : urls) {
                if (!url.isRegularFile()) continue;
                urls.add(url);
            }
        }
        return Collections.unmodifiableSet(inputURLs);
    }

    @Override
    public List<OutputURLParameter> getOutputURLParameters() {
        LinkedList<OutputURLParameter> outputURLParameters = new LinkedList<OutputURLParameter>();
        for (ParameterGroup group : this.getGroups()) {
            outputURLParameters.addAll(group.getOutputURLParameters());
        }
        return Collections.unmodifiableList(outputURLParameters);
    }

    @Override
    public Set<FileURLValue> getOutputURLs() {
        HashSet<FileURLValue> outputFiles = new HashSet<FileURLValue>();
        List<OutputURLParameter> outputURLParameters = this.getOutputURLParameters();
        for (OutputURLParameter outputURLParameter : outputURLParameters) {
            FileURLValue file;
            if (!outputURLParameter.isVisible() && outputURLParameter.ignoreIfInvisible() || !outputURLParameter.isEnabled() && outputURLParameter.ignoreIfDisabled() || (file = (FileURLValue)outputURLParameter.getValue()) == null || !file.isRegularFile()) continue;
            outputFiles.add(file);
        }
        for (OutputURLListParameter outputURLListParameter : this.getOutputURLListParameters()) {
            List files;
            if (!outputURLListParameter.isVisible() && outputURLListParameter.ignoreIfInvisible() || !outputURLListParameter.isEnabled() && outputURLListParameter.ignoreIfDisabled() || (files = (List)outputURLListParameter.getValue()) == null) continue;
            for (FileURLValue file : files) {
                if (!file.isRegularFile()) continue;
                outputFiles.add(file);
            }
        }
        return Collections.unmodifiableSet(outputFiles);
    }

    @Override
    public String getParameterLabel(String parameterName) throws ParameterNotFoundException {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        for (ParameterGroup group : this.getGroups()) {
            SimpleParameter<?> parameter = group.getSimpleParameter(parameterName);
            if (parameter == null) continue;
            return parameter.getLabel();
        }
        throw new ParameterNotFoundException(parameterName, this.toString());
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> parameterNames = new HashSet<String>();
        for (ParameterGroup group : this.getGroups()) {
            for (SimpleParameter<?> parameter : group.getSimpleParameters()) {
                parameterNames.add(parameter.getName());
            }
        }
        return Collections.unmodifiableSet(parameterNames);
    }

    @Override
    public String getParameterType(String parameterName) throws ParameterNotFoundException {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        for (ParameterGroup group : this.getGroups()) {
            SimpleParameter<?> parameter = group.getSimpleParameter(parameterName);
            if (parameter == null) continue;
            return parameter.getType();
        }
        throw new ParameterNotFoundException(parameterName, this.toString());
    }

    @Override
    public String getParameterValue(String parameterName) throws ParameterNotFoundException {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        for (ParameterGroup group : this.getGroups()) {
            SimpleParameter<?> parameter = group.getSimpleParameter(parameterName);
            if (parameter == null) continue;
            return parameter.getValueAsText();
        }
        throw new ParameterNotFoundException(parameterName, this.toString());
    }

    @Override
    public Set<String> getPlatforms() {
        Vector<String> platformVector = this.getAlgorithmVersion().getSupportedPlatforms();
        HashSet<String> platformSet = new HashSet<String>();
        Iterator<String> i$ = platformVector.iterator();
        while (i$.hasNext()) {
            String platformAsObject;
            String platform = platformAsObject = i$.next();
            platformSet.add(platform);
        }
        return Collections.unmodifiableSet(platformSet);
    }

    public String getShell() {
        return this.shell;
    }

    public SimpleParameter<?> getSimpleParameter(String parameterName) {
        List<SimpleParameter<?>> parameters = this.getSimpleParameters();
        for (SimpleParameter<?> parameter : parameters) {
            if (!parameter.getName().equals(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    public List<SimpleParameter<?>> getSimpleParameters() {
        LinkedList parameters = new LinkedList();
        for (ParameterGroup group : this.getGroups()) {
            parameters.addAll(group.getSimpleParameters());
        }
        return Collections.unmodifiableList(parameters);
    }

    public Set<Trigger<?>> getTriggers() {
        return Collections.unmodifiableSet(this.triggers);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isSetDefaultValues() {
        for (ParameterGroup group : this.getGroups()) {
            if (group.isSetDefaultValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void importValues(Map<Object, Object> parameterValues) {
        if (parameterValues == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterValues est\u00e1 nulo.");
        }
        for (ParameterGroup group : this.getGroups()) {
            group.importValue(parameterValues);
        }
    }

    @Override
    public String makeCommandLine(CommandLineContext context) {
        char fileSeparator = context.getFileSeparator();
        CommandLineBuilder builder = new CommandLineBuilder(context.isScript());
        builder.append(this.makeEnvironmentVariablesDeclaration(context));
        builder.append("( ");
        String execDirPath = CommandLineBuilder.makeEnvironmentVariableReference(EnvironmentVariable.EXECUTION_DIR);
        builder.append("cd ").append(execDirPath).append(" && ");
        builder.append("( ");
        if (this.getShell() != null) {
            builder.append(this.getShell()).append(" ");
        }
        String binaryPath = CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.BINARY_DIR, this.getCommandBinaryName(), fileSeparator);
        builder.append(binaryPath);
        StringBuilder parameterListBuilder = new StringBuilder();
        Iterator<ParameterGroup> groupIterator = this.getGroups().iterator();
        String parameterSeparator = "";
        while (groupIterator.hasNext()) {
            ParameterGroup group = groupIterator.next();
            String groupCommandLine = group.getCommandLine(context);
            if (groupCommandLine == null) continue;
            parameterListBuilder.append(parameterSeparator);
            parameterListBuilder.append(groupCommandLine);
            parameterSeparator = " ";
        }
        for (HiddenParameter parameter : this.getHiddenParameters()) {
            parameterListBuilder.append(parameterSeparator);
            parameterListBuilder.append(parameter.getCommandLine());
            parameterSeparator = " ";
        }
        String parameterList = parameterListBuilder.toString();
        if (parameterList.length() != 0) {
            builder.append(" ");
            builder.append(parameterList);
        }
        if (this.provideId()) {
            builder.append(" cmdId=").append(context.getCommandId());
        }
        String standardOutputFile = null;
        if (this.getStandardOutputFile() != null) {
            standardOutputFile = CommandLineBuilder.makeEnvironmentVariableReference(EnvironmentVariable.LOG_FILE);
        }
        if (this.showOutput) {
            if (standardOutputFile != null) {
                builder.append(" )");
                builder.append(this.getExitCodeCaptureCommand(context));
                builder.append(")");
                builder.redirectStdErrToStdOutput();
                builder.append(" | tee -a ");
                builder.append(standardOutputFile);
            } else {
                builder.append(" ))");
                builder.append(this.getExitCodeCaptureCommand(context));
            }
        } else {
            builder.append(" ))");
            if (standardOutputFile != null) {
                builder.redirectStdErrAndStdOutputToFile(standardOutputFile);
            } else {
                builder.discardStdErrAndStdOutput();
            }
            builder.append(this.getExitCodeCaptureCommand(context));
        }
        String commandLine = builder.toString();
        return commandLine;
    }

    protected String makeEnvironmentVariablesDeclaration(CommandLineContext context) {
        String commandValue;
        String commandValue2;
        String clientHostName;
        String executionDirectory;
        char fileSeparator = context.getFileSeparator();
        CommandLineBuilder commandLineBuilder = new CommandLineBuilder(context.isScript());
        Integer nodeId = context.getNodeIdForFlow();
        if (nodeId != null) {
            commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.FLOW_NODE_ID, String.valueOf(nodeId));
        }
        String binDir = FileUtils.joinPath((char)fileSeparator, (String[])new String[]{context.getAlgorithmRootDirectory(), this.getBinaryDirectory(context.getPlatformId(), fileSeparator)});
        commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.BINARY_DIR, binDir);
        String projectDir = FileUtils.joinPath((char)fileSeparator, (String[])new String[]{context.getProjectRootDirectory(), context.getProjectDirectory()});
        commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.PROJECT_DIR, projectDir);
        String sandboxDir = FileUtils.joinPath((char)fileSeparator, (String[])new String[]{context.getSandboxRootDirectory(), context.getSandboxDirectory()});
        commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.SANDBOX_DIR, sandboxDir);
        switch (this.getExecutionLocation()) {
            case BINARY_DIR: {
                executionDirectory = CommandLineBuilder.makeEnvironmentVariableReference(EnvironmentVariable.BINARY_DIR);
                break;
            }
            case PERSISTENCY_DIR: {
                executionDirectory = context.getPersistenceDirectory();
                break;
            }
            case SANDBOX: {
                executionDirectory = CommandLineBuilder.makeEnvironmentVariableReference(EnvironmentVariable.SANDBOX_DIR);
                break;
            }
            default: {
                throw new IllegalStateException("Esse tipo de execu\u00e7\u00e3o n\u00e3o \u00e9 suportada");
            }
        }
        commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.EXECUTION_DIR, executionDirectory);
        FileURLValue standardOutputFile = this.getStandardOutputFile();
        if (standardOutputFile != null) {
            String standardOutputPath = CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, standardOutputFile.getPath(), fileSeparator);
            commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.LOG_FILE, standardOutputPath);
        }
        if ((clientHostName = context.getClientHostName()) != null && !clientHostName.isEmpty()) {
            commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.CLIENT_HOST, clientHostName);
        }
        StringBuilder inputFilesVarValue = new StringBuilder();
        for (InputFileParameter inputFile : this.getInputFileParameters()) {
            commandValue2 = inputFile.getCommandValue(context);
            if (commandValue2 == null) continue;
            inputFilesVarValue.append(commandValue2);
            inputFilesVarValue.append(",");
        }
        for (InputFileListParameter inputFileList : this.getInputFileListParameters()) {
            commandValue2 = inputFileList.getCommandValue(context);
            if (commandValue2 == null) continue;
            inputFilesVarValue.append(commandValue2);
            inputFilesVarValue.append(",");
        }
        if (inputFilesVarValue.length() > 0) {
            inputFilesVarValue.deleteCharAt(inputFilesVarValue.lastIndexOf(","));
            commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.INPUT_FILES, inputFilesVarValue.toString());
        }
        StringBuilder outputFilesVarValue = new StringBuilder();
        for (OutputFileParameter outputFile : this.getOutputFileParameters()) {
            commandValue = outputFile.getCommandValue(context);
            if (commandValue == null) continue;
            outputFilesVarValue.append(commandValue);
            outputFilesVarValue.append(",");
        }
        for (OutputFileListParameter outputFileList : this.getOutputFileListParameters()) {
            commandValue = outputFileList.getCommandValue(context);
            if (commandValue == null) continue;
            outputFilesVarValue.append(commandValue);
            outputFilesVarValue.append(",");
        }
        if (outputFilesVarValue.length() > 0) {
            outputFilesVarValue.deleteCharAt(outputFilesVarValue.lastIndexOf(","));
            commandLineBuilder.appendEnvironmentVariableDeclaration(EnvironmentVariable.OUTPUT_FILES, outputFilesVarValue.toString());
        }
        return commandLineBuilder.toString();
    }

    @Override
    public void resetValues() {
        for (ParameterGroup parameterGroup : this.getGroups()) {
            parameterGroup.resetValue();
        }
    }

    @Override
    public boolean setDefaultInputFile(FileURLValue inputFile) {
        if (this.getDefaultInputFileParameterName() == null) {
            return false;
        }
        for (InputFileParameter inputFileParameter : this.getInputFileParameters()) {
            if (!inputFileParameter.getName().equals(this.getDefaultInputFileParameterName())) continue;
            inputFileParameter.setValue(inputFile);
            return true;
        }
        return false;
    }

    @Override
    public boolean setEnabled(boolean isEnabled) {
        if (this.isEnabled == isEnabled) {
            return false;
        }
        for (SimpleParameter<?> parameter : this.getSimpleParameters()) {
            parameter.setEnabled(isEnabled);
        }
        if (isEnabled) {
            this.updateTriggers();
        }
        this.isEnabled = isEnabled;
        this.fireWasSetEnabled();
        return true;
    }

    @Override
    public void setParameterValue(String parameterName, String parameterValue) throws ParseException, ParameterNotFoundException {
        if (parameterName == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterName est\u00e1 nulo.");
        }
        for (ParameterGroup group : this.getGroups()) {
            SimpleParameter<?> parameter = group.getSimpleParameter(parameterName);
            if (parameter == null) continue;
            parameter.setValueAsText(parameterValue);
            return;
        }
        throw new ParameterNotFoundException(parameterName, this.toString());
    }

    public void updateTriggers() {
        for (Trigger<?> trigger : this.triggers) {
            trigger.update(this);
        }
    }

    @Override
    protected String getCurrentParameterFileVersion() {
        return "1.0";
    }

    private String getBinaryDirectory(String platformId, char fileSeparator) {
        String[] path = this.getBinaryDirectoryAsArray(platformId);
        return FileUtils.joinPath((char)fileSeparator, (String[])path);
    }

    private String[] getBinaryDirectoryAsArray(String platformId) {
        AlgorithmVersionInfo versionInfo = this.getAlgorithmVersion();
        String algorithmDirectoryName = versionInfo.getInfo().getDirectory();
        String versionsDirectoryName = versionInfo.getVersionsDirName();
        String versionDirectoryName = versionInfo.getDirectory();
        String binariesDirectoryName = versionInfo.getBinDirName();
        String[] binaryDirectory = new String[]{algorithmDirectoryName, versionsDirectoryName, versionDirectoryName, binariesDirectoryName, platformId};
        return binaryDirectory;
    }

    private void setCommandBinaryName(String command) {
        if (command == null) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        this.commandBinaryName = command;
    }

    @Override
    public Validation validate(ValidationContext context) throws RemoteException {
        for (ParameterGroup groupView : this.groups) {
            Validation validation = groupView.validate(context);
            if (validation.isWellSucceded()) continue;
            return validation;
        }
        return new ValidationSuccess();
    }
}

