/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.validation;

import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;

public abstract class ElementValidationResult<E>
implements Validation {
    protected E element;
    protected LocalizedMessage message;

    public ElementValidationResult(Validation validation, E element) {
        if (validation == null) {
            throw new IllegalArgumentException("O par\u00e2metro validation est\u00e1 nulo.");
        }
        if (!validation.isWellSucceded()) {
            this.setErrorMessage(validation.getMessage());
        }
        this.setElement(element);
    }

    public ElementValidationResult(LocalizedMessage message, E element) {
        this.setErrorMessage(message);
        this.setElement(element);
    }

    public E getElement() {
        return this.element;
    }

    @Override
    public LocalizedMessage getMessage() {
        return this.message;
    }

    @Override
    public boolean isWellSucceded() {
        return this.message == null;
    }

    protected void setErrorMessage(LocalizedMessage errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("O par\u00e2metro errorMessage est\u00e1 nulo.");
        }
        this.message = errorMessage;
    }

    protected void setElement(E element) {
        if (element == null) {
            throw new IllegalArgumentException("O par\u00e2metro element est\u00e1 nulo.");
        }
        this.element = element;
    }
}

