package csbase.logic.algorithms.parsers;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.OutputURLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;

/**
 * <p>
 * Analisador de {@link OutputURLListParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "url de sada" mltiplo. O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link OutputURLListParameter}.
 * </p>
 * 
 */
public class OutputURLListParameterParser extends
  AbstractURLParameterParser<OutputURLListParameter> {

  @Override
  protected OutputURLListParameter createURLParameter(XmlParser parser, 
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, String type,
    String localization, FileParameterMode mode, FileURLValue defaultValue,
    FileParameterPipeAcceptance usesPipe, EnumSet<URLProtocol> allowedProtocols)
    throws ParseException {

    boolean mustSort =
      parser.extractAttributeValueAsBoolean(MUST_SORT_ATTRIBUTE,
        MUST_SORT_DEFAULT_VALUE);

    List<FileURLValue> defaultValues =
      defaultValue == null ? null : Arrays.asList(defaultValue);
    return new OutputURLListParameter(name, label, description, defaultValues,
      isOptional, isVisible, commandLinePattern, localization, type, mode,
      mustSort, allowedProtocols);
  }
}
