/*
 * $Id: ServiceFailureException.java 88415 2009-02-13 22:28:01Z clinio $
 */
package csbase.exception;

import java.text.MessageFormat;

/**
 * A classe <code>ServiceFailureException</code> representa uma falha durante a
 * execuo de um pedido de servio. Esse tipo de falha sempre deve estar
 * associado a uma descrio adequada para exibio ao usurio.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ServiceFailureException extends CSBaseRuntimeException {
  /**
   * Mensagem detalhada da exceo.
   */
  private String detailMessage;

  /**
   * Retorna uma descrio do erro que pode ser repassada para o cliente.
   * 
   * @return A descrio do erro.
   */
  public String getClientMessage() {
    return super.getMessage();
  }

  /**
   * Sobrescrevendo para incluir a informao adicional para o log do servidor.
   * 
   * @return A mensagem de descrio do erro.
   */
  @Override
  public String getMessage() {
    String message = super.getMessage();
    if (null != detailMessage) {
      message += "\n\n" + detailMessage + "\n";
    }
    return message;
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param clientMessage a descrio do erro
   */
  public ServiceFailureException(String clientMessage) {
    super(clientMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   * 
   * @see MessageFormat
   */
  public ServiceFailureException(String pattern, Object... arguments) {
    super(pattern, arguments);
  }

  /**
   * Constri uma exceo contendo a causa do erro e uma informao adicional
   * para o log do servidor.
   * 
   * @param clientMessage A descrio do erro.
   * @param detailMessage A informao adicional.
   */
  public ServiceFailureException(String clientMessage, String detailMessage) {
    this(clientMessage);
    this.detailMessage = detailMessage;
  }

  /**
   * Constri uma exceo contendo a causa do erro e uma informao adicional
   * para o log do servidor.
   * 
   * @param clientMessage A descrio do erro.
   * @param detailMessage A informao adicional.
   * @param throwable A causa do erro.
   */
  public ServiceFailureException(String clientMessage, String detailMessage,
    Throwable throwable) {
    this(clientMessage, throwable);
    this.detailMessage = detailMessage;
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param clientMessage a descrio do erro
   * @param exception a exceo original
   */
  public ServiceFailureException(String clientMessage, Throwable exception) {
    super(clientMessage, exception);
  }
}
