/*
 * $Id:$
 */

package csbase.exception.algorithms;

import csbase.exception.CSBaseException;

/**
 * Exceo que indica que um algoritmo no  vlido.
 * 
 * Por exemplo, um algoritmo pode ser invlido em uma aplicao porque no
 * contm o conjunto de parmetros requerido ou no tem um parmetro de
 * determinado tipo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class AlgorithmNotValidException extends CSBaseException {

  /**
   * Constri a exceo, com uma mensagem de texto.
   * 
   * @param message mensagem de texto que representa a sua causa
   * 
   */
  public AlgorithmNotValidException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo com uma mensagem e com a causa/exceo original.
   * 
   * @param exception a exceo original
   * @param message mensagem de texto que representa a sua causa
   */
  public AlgorithmNotValidException(String message, Throwable exception) {
    super(message, exception);
  }

  /**
   * Constri uma exceo com a causa/exceo original.
   * 
   * @param exception a exceo original
   */
  public AlgorithmNotValidException(Throwable exception) {
    super(exception);
  }
}
