package csbase.exception.algorithms;

import csbase.exception.CSBaseRuntimeException;
import csbase.logic.algorithms.validation.Validation;

/**
 * Exceo gerada por falha na validao de um valor de um parmetro.
 */
public class AlgorithmValidationException extends CSBaseRuntimeException {

  /**
   * Erro de validao.
   */
  private Validation validation;

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param validation o erro de validao.
   */
  public AlgorithmValidationException(Validation validation) {
    super();
    this.validation = validation;
  }

  /**
   * Constri uma exceo contendo a causa/exceo original.
   * 
   * @param exception a exceo original
   */
  public AlgorithmValidationException(Throwable exception) {
    super(exception);
  }

  /**
   * Obtm o erro de validao.
   * 
   * @return o erro.
   */
  public Validation getValidationResult() {
    return validation;
  }

}
