package csbase.logic;

/**
 * Enumerao para definio de tipos de otimizao de acesso  arquivos de
 * projeto
 * 
 *
 * @author Tecgraf
 */
public enum ClientOptimizationMode {

  /**
   * Nenhuma otimizao. Operaes de IO nestes arquivos sero sempre via
   * ServiceProject
   */
  NONE,

  /**
   * Otimizao que assume que h um path montado localmente em todas as
   * mquinas que executam o cliente, a partir do qual os arquivos de qualquer
   * projeto podem ser acessados localmente por qualquer usurio.
   */
  GLOBAL;

  /**
   * 
   * @param string Modo de otimizao
   * @return o Modo de otimizao a partir da string definida na propriedade de
   *         ProjectService. Se for passado algum valor no reconhecido, retorna
   *         null.
   */
  public static ClientOptimizationMode getClientOptimizationMode(
    String string) {
    for (ClientOptimizationMode com : values()) {
      if (com.name().equalsIgnoreCase((string))) {
        return com;
      }
    }
    return null;
  }
}
