/*
 * $Id$
 */

package csbase.logic.algorithms;

import java.io.File;
import java.io.Serializable;

import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;

public class ConfigurationPathFactory implements IPathFactory, Serializable {

  private AlgorithmVersionInfo version;

  public ConfigurationPathFactory(AlgorithmVersionInfo version) {
    this.version = version;
  }

  @Override
  public String getPath(FileInfo fileInfo) {
    return version.getConfiguratorDirPath() + File.separator
      + fileInfo.getPath();
  }
}
