/*
 * $Id$
 */
package csbase.logic.algorithms;

import java.io.Serializable;

import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

/**
 * Estrutura que mantm as informaes necessrias para a importao do arquivo
 * de pacote de algoritmos.
 */
public class ImportAlgorithmsPackTransferInfo implements Serializable {
  /** Canal ftc de transferncia do arquivo que representa o PA */
  private RemoteFileChannelInfo channel;

  /** Identificador nico de um dado de importao de PA */
  private String importDataToken;

  /**
   * @param channel
   * @param importDataToken
   */
  public ImportAlgorithmsPackTransferInfo(RemoteFileChannelInfo channel,
    String importDataToken) {
    super();
    this.channel = channel;
    this.importDataToken = importDataToken;
  }

  /**
   * Retorna
   * 
   * @return channel
   */
  public RemoteFileChannelInfo getChannel() {
    return channel;
  }

  /**
   * @param channel
   */
  public void setChannel(RemoteFileChannelInfo channel) {
    this.channel = channel;
  }

  /**
   * Retorna
   * 
   * @return importDataToken
   */
  public String getImportDataToken() {
    return importDataToken;
  }

  /**
   * @param importDataToken
   */
  public void setImportDataToken(String importDataToken) {
    this.importDataToken = importDataToken;
  }

}
