package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * Condio sempre verdadeira.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class TrueCondition implements Condition {

  /**
   * A instncia nica (Singleton).
   */
  private static TrueCondition instance = new TrueCondition();

  /**
   * Cria a instncia.
   */
  private TrueCondition() {

  }

  /**
   * Obtm a instncia nica (Singleton).
   * 
   * @return .
   */
  public static TrueCondition getInstance() {
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean evaluate(SimpleAlgorithmConfigurator configurator) {
    return true;
  }

}
