package csbase.logic.algorithms.parsers;

import java.util.EnumSet;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.InputURLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.FileURLValue;

/**
 * Analisador de parmetros URL de entrada.
 *
 * @author Tecgraf
 */
public final class InputURLParameterParser extends
  AbstractURLParameterParser<InputURLParameter> {

  @Override
  protected InputURLParameter createURLParameter(XmlParser parser, String name, 
      String label, String description, boolean isOptional, boolean isVisible,
      String commandLinePattern, String[] types, String localization,
      FileParameterMode mode, FileURLValue defaultValue,
      FileParameterPipeAcceptance usesPipe,
      EnumSet<URLProtocol> allowedProtocols) throws ParseException {

    if(usesPipe != FileParameterPipeAcceptance.FALSE && types.length > 1) {
      throw new ParseException(
        "O valor {0} do atributo {1}  invlido quando se tem mais de um tipo " +
          "de arquivo definido no parmetro.",
        usesPipe, CAN_USE_PIPE_ATTRIBUTE);
    }

    return new InputURLParameter(name, label, description, defaultValue,
      isOptional, isVisible, commandLinePattern, localization, types, mode,
      usesPipe, allowedProtocols);
  }
}
