package csbase.logic.algorithms.parsers.columns;

import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.AbstractEnumerationParameterParser;
import csbase.logic.algorithms.parsers.EnumerationItemFactory;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica para {@link EnumerationColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class EnumerationColumnFactory extends AbstractTableColumnFactory {
  /**
   * <p>
   * O elemento {@value #ELEMENT_NAME}: indica que o {@link TableParameter
   * parmetro do tipo tabela} que que est descrita no elemento-pai deste
   * elemento ter uma {@link EnumerationColumn coluna do tipo enumerao}.
   * </p>
   */
  private static final String ELEMENT_NAME = "coluna_de_enumeracao";

  /**
   * Cria a fbrica.
   */
  public EnumerationColumnFactory() {
    super(ELEMENT_NAME);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setCellValue(XmlParser parser, String parameterName,
    TableColumn<?> column, int rowIndex, String valueAttributeName)
      throws ParseException {
    EnumerationColumn enumerationColumn = (EnumerationColumn) column;
    String id = parser.extractAttributeValue(valueAttributeName);
    EnumerationItemFactory factory = new EnumerationItemFactory();
    EnumerationItem cellValue = factory.getEnumerationItem(String.format(
      "%s[%s]", parameterName, id), enumerationColumn.getItems(), id);
    enumerationColumn.addDefaultValue(rowIndex, cellValue);
  }

  /**
   * {@inheritDoc}
   *
   * @param parameterName
   */
  @Override
  protected EnumerationColumn createColumn(XmlParser parser,
    String parameterName, String label, String id, boolean isOptional,
    boolean isEditable, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    String defaultItemId = parser.extractAttributeValue(
      COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
    EnumerationItemFactory factory = new EnumerationItemFactory();
    List<EnumerationItem> items = factory.loadEnumerationItems(parser,
      parameterName);
    boolean mustSort = parser.extractAttributeValueAsBoolean(
      AbstractEnumerationParameterParser.ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE,
      AbstractEnumerationParameterParser.ENUMERATION_ELEMENT_MUST_SORT_DEFAULT_VALUE);
    EnumerationItem defaultItem = factory.getEnumerationItem(String.format(
      "%s[%s]", parameterName, id), items, defaultItemId);
    parser.checkAttributes();
    return new EnumerationColumn(id, label, defaultItem, items, mustSort);
  }
}
