package csbase.logic.algorithms.xml.category;

import java.util.Hashtable;
import java.util.Map;

import tecgraf.javautils.xml.XMLElementFactory;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLEmptyElement;
import csbase.logic.algorithms.CategorySet;

/**
 * Esta classe implementa a fbrica de elementos XML para categorias de
 * algoritmos.
 * 
 * Ela permite associar objetos da aplicao com a tag raiz do documento que
 * ser persistido. Permite tambm associar as tags XML com as respectivas
 * classes dos seus elementos, necessrias tanto para leitura quanto para
 * escrita.
 * 
 */
public class XmlCategoriesFactory extends XMLElementFactory {
  /** Tabela de mapeamento - usada pelo Writer */
  private Hashtable<String, Class<? extends XMLElementInterface>> tagToXMLMap;

  /** Tabela de mapeamento - usada pelo Writer */
  private Hashtable<Class<?>, String> appObjectToTagMap;

  /** Objeto da aplicao associado ao contexto de leitura */
  private Object appContextObject;

  /**
   * Constri a fbrica de elementos para categorias de algoritmos.
   * 
   * @param categorySet conjunto de categorias
   */
  public XmlCategoriesFactory(CategorySet categorySet) {
    setAppContextObject(categorySet);
  }

  @Override
  public void setAppContextObject(Object contextApplication) {
    this.appContextObject = contextApplication;
  }

  @Override
  public Object getAppContextObject() {
    return this.appContextObject;
  }

  @Override
  protected void fillConversionTables() {
    if (tagToXMLMap == null) {
      tagToXMLMap =
        new Hashtable<String, Class<? extends XMLElementInterface>>();
    }
    if (appObjectToTagMap == null) {
      appObjectToTagMap = new Hashtable<Class<?>, String>();
    }
    mapAppClassToTag(CategorySet.class, XmlCategoriesUtils.CATEGORIES_TAG);

    // Associao das tags com as classes XML
    mapTagToXMLClass(XmlCategoriesUtils.CATEGORIES_TAG,
      XmlCategoriesElement.class);
    mapTagToXMLClass(XmlCategoriesUtils.CATEGORY_TAG, XmlCategoryElement.class);
    mapTagToXMLClass(XmlCategoriesUtils.ALGORITHM_TAG, XMLEmptyElement.class);
  }

  @Override
  protected Map<String, Class<? extends XMLElementInterface>> getTagToXMLMap() {
    return this.tagToXMLMap;
  }

  @Override
  protected Map<Class<?>, String> getAppObjectToTagMap() {
    return this.appObjectToTagMap;
  }
}
