package csbase.exception;

/**
 * A classe <code>BugException</code> representa uma erro
 * (bug) durante a execuo de um pedido de servio, tipicamente
 * reportado por uma exceo lanada pela JVM.
 * 
 * Esse tipo de erro no  associado a uma descrio especfica.
 */
public class BugException extends CSBaseRuntimeException {

  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public BugException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * @param message a descrio do erro
   */
  public BugException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public BugException(String message, Throwable exception) {
    super(message, exception);
  }

  /**
   * Constri uma exceo contendo a causa/exceo
   * original.
   * @param cause a exceo original
   */
  public BugException(Throwable cause) {
    super(cause);
  }
}
