package csbase.logic;

import java.util.Locale;

/**
 * Estrutura que armazenas as informaes de login de um usurio
 */
public class LoginInfo {
  private String loginName;
  private String password;
  private Locale locale;

  /**
   * Cria uma estrutura que representa um login de um usurio.
   *
   * @param loginName login do usurio
   * @param password senha do usurio
   * @param locale idioma selecionado
   */
  public LoginInfo(String loginName, String password, Locale locale) {
    this.loginName = loginName;
    this.password = password;
    this.locale = locale;
  }

  /**
   * Recupera o login do usurio.
   *
   * @return O nome do login.
   */
  public String getLoginName() {
    return loginName;
  }

  /**
   * Recupera a senha do usurio.
   *
   * @return A senha.
   */
  public String getPassword() {
    return password;
  }

  /**
   * Grava a senha do usurio.
   *
   * @param newPassword .
   */
  public void setPassword(String newPassword) {
    this.password = newPassword;
  }

  /**
   * Recupera o idioma selecionado pelo usurio.
   *
   * @return A locale.
   */
  public Locale getLocale() {
    return locale;
  }
}
