/*
 * RoleInfo.java
 *
 * $Author: brunoos $
 * $Revision: 34611 $  - $Date: 2004-10-19 07:40:53 -0300 (Tue, 19 Oct 2004) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * A classe <code>RoleInfo</code> contm informaes de um perfil de usurio.
 *
 * @author Maria Julia
 * @version $Revision: 34611 $
 */
public class RoleInfo implements Serializable, Cloneable {
  /** Nome do perfil. */
  public String name;
  /** Descrio do perfil */
  public String description;
  /** Permisses do perfil */
  public Object[] permissionIds;

  /**
   * Constri um RoleInfo.
   *
   * @param name .
   * @param description .
   * @param permissionIds .
   */
  public RoleInfo(String name, String description, Object[] permissionIds) {
    this.name = (name!=null ? name : "");
    this.description = (description!=null ? description : "");
    this.permissionIds = (permissionIds!=null ? permissionIds : new Object[0]);
  }

  public boolean equals(Object obj) {
    if (!(obj instanceof RoleInfo)) {
      return false;
    }
    RoleInfo info = (RoleInfo)obj;
    return name.equals(info.name) && description.equals(info.description);
  }

  /**
   * Calcula o cdigo hash do objeto.
   *
   * @return Inteiro que representa o cdigo hash do objeto.
   */
  public int hashCode() {
    return ( name + description).hashCode();
  }

  public Object clone() {
    try {
      return super.clone();
    }
    catch (CloneNotSupportedException e) {
      return null;
    }
  }

  public String toString() {
    StringBuffer str = new StringBuffer(name+" - "+description+" - ");
    for (int i=0; i<permissionIds.length; i++) {
      str.append(permissionIds[i]).append(",");
    }
    return str.toString();
  }
}
