/* 
 * $Id$ 
 */

package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * Representa uma alterao no estado da fila do agendador de comandos.
 * Os possveis estados so bloqueada ou no bloqueada.
 *
 * @author Tecgraf / PUC-Rio
 */
public class SchedulerStateChangedEvent extends RemoteEvent {
  
  /** Flag indicando se a fila foi levada ao estado de bloqueada. */
  private final boolean blocked;
  
  /**
   * Construtor.
   * 
   * @param blocked indica se a fila foi levada ao estado de bloqueada.
   */
  public SchedulerStateChangedEvent(boolean blocked) {
    this.blocked = blocked;
  }
  
  /**
   * Indica se a fila est bloqueada.
   * 
   * @return true se a fila estiver bloqueada, ou false caso contrrio
   */
  public boolean isBlocked() {
    return blocked;
  }
}
