package csbase.logic.algorithms.flows.configurator;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class Output implements Serializable {

  private Set<Input> inputs;
  private int nodeId;
  private String parameterName;
  private boolean isDir;

  public Output(int nodeId, String parameterName, boolean isDir) {
    this.inputs = new HashSet<Input>();
    setDir(isDir);
    setNodeId(nodeId);
    setParameterName(parameterName);
  }

  public boolean isDir() {
    return isDir;
  }

  private void setDir(boolean isDir) {
    this.isDir = isDir;
  }

  public boolean addInput(Input input) {
    if (input == null) {
      throw new IllegalArgumentException("O parmetro input est nulo.");
    }
    return this.inputs.add(input);
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (!getClass().equals(obj.getClass())) {
      return false;
    }
    Output output = (Output) obj;
    if (output.getNodeId() != getNodeId()) {
      return false;
    }
    if (!output.getParameterName().equals(getParameterName())) {
      return false;
    }
    return true;
  }

  public Collection<Input> getInputs() {
    return Collections.unmodifiableCollection(this.inputs);
  }

  public int getNodeId() {
    return this.nodeId;
  }

  public String getParameterName() {
    return this.parameterName;
  }

  @Override
  public int hashCode() {
    return getNodeId();
  }

  public boolean removeInput(int nodeId, String parameterName) {
    if (parameterName == null) {
      throw new IllegalArgumentException("O parmetro parameterName est nulo.");
    }
    Iterator<Input> inputIterator = this.inputs.iterator();
    while (inputIterator.hasNext()) {
      Input input = inputIterator.next();
      if ((input.getNodeId() == nodeId)
        && input.getParameterName().equals(parameterName)) {
        inputIterator.remove();
        return true;
      }
    }
    return false;
  }

  private void setNodeId(int nodeId) {
    this.nodeId = nodeId;
  }

  private void setParameterName(String parameterName) {
    if (parameterName == null) {
      throw new IllegalArgumentException("O parmetro parameterName est nulo.");
    }
    this.parameterName = parameterName;
  }
}
