package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * <p>
 * Analisador de {@link IntegerListParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "lista de inteiros". O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link IntegerListParameter}.
 * </p>
 */
public class IntegerListParameterFactory extends
  AbstractIntegerParameterParser<IntegerListParameter> {

  /**
   * <p>
   * O elemento {@value #INTEGER_LIST_PARAMETER_ELEMENT}: indica que o
   * {@link ParameterGroup grupo} que que est descrito no elemento-pai deste
   * elemento ter uma {@link IntegerListParameter parmetro do tipo lista de
   * inteiros}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String INTEGER_LIST_PARAMETER_ELEMENT =
    "lista_de_inteiros";

  /**
   * {@inheritDoc}
   */
  @Override
  protected IntegerListParameter createIntegerParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, Integer maximum,
    Integer minimum) throws ParseException {
    return new IntegerListParameter(name, label, description, null, isOptional,
      isVisible, commandLinePattern, maximum, minimum);
  }

}
