package csbase.logic.algorithms.parsers.triggers;

import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.triggers.Trigger;

/**
 * <p>
 * Classe abstrata para simplificar a criao de {@link TriggerFactory fbricas
 * de gatilhos} de {@link SimpleParameter parmetros simples}.
 * </p>
 * 
 * <p>
 * Ela implementa os mtodos requiridos deixando mtodos abstratos nos pontos
 * que so especficos de acordo com o tipo de fbrica.
 * </p>
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractSimpleTriggerFactory extends
  AbstracTriggerFactory implements TriggerFactory {

  /**
   * <p>
   * O atributo {@value #PARAMETER_ATTRIBUTE} de elementos que representam
   * {@link Trigger gatilhos}.
   * </p>
   * <p>
   * Indica o nome do parmetro que ser manipulado pelo gatilho.  opcional e 
   * do tipo string. Ele  opcional, pois pode-se utilizar o elemento
   * {@link #PARAMETER_ELEMENT} com o mesmo sentido, portanto pelo menos um dos
   * 2 tem que existir.
   * </p>
   */
  private static final String PARAMETER_ATTRIBUTE = "parametro";

  /**
   * <p>
   * O elemento {@value #PARAMETER_ELEMENT}: indica o parmetro que ser
   * manipulado pelos gatilhos.
   * </p>
   * <p>
   *  elemento-filho de o elemento de um gatilho.
   * </p>
   */
  private static final String PARAMETER_ELEMENT = "parametro";

  /**
   * O atributo {@value #PARAMETER_ELEMENT_NAME_ATTRIBUTE} do elemento que
   * indica o parmetro manipulado pelos gatilhos.  obrigatrio e  do tipo
   * string.
   */
  private static final String PARAMETER_ELEMENT_NAME_ATTRIBUTE = "nome";

  /**
   * Cria a fbrica.
   * 
   * @param elementName O nome do elemento que define as propriedades do
   *        gatilho.
   * @param allowMultiples Indica se essa fbrica  capaz de criar mltiplas
   *        instncias do mesmo {@link Trigger gatilhos}.
   */
  protected AbstractSimpleTriggerFactory(String elementName,
    boolean allowMultiples) {
    super(elementName, PARAMETER_ELEMENT, PARAMETER_ELEMENT_NAME_ATTRIBUTE,
      PARAMETER_ATTRIBUTE, allowMultiples);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final Parameter<?> findParameter(
    SimpleAlgorithmConfigurator configurator, String parameterName) {
    return configurator.getSimpleParameter(parameterName);
  }
}