package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeLabelTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link ChangeLabelTrigger}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ChangeLabelTriggerFactory extends
  AbstractSimpleTriggerFactory {

  /**
   * Atributo {@value #NEW_LABEL_ATTRIBUTE}: indica o novo rtulo para o
   * parmetro,  obrigatrio e  do tipo string.
   */
  private static final String NEW_LABEL_ATTRIBUTE = "novo_rotulo";

  /**
   * Cria a fbrica.
   */
  public ChangeLabelTriggerFactory() {
    super("trocar_rotulo", false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition,
    Parameter<?> parameter, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    String newLabel = parser.extractAttributeValue(NEW_LABEL_ATTRIBUTE);
    SimpleParameter<?> simpleParameter = (SimpleParameter<?>) parameter;
    return new ChangeLabelTrigger(simpleParameter, condition, newLabel);
  }
}
