/*
 * ProjectSynchronizationData.java
 * $Author: cassino $
 * $Revision: 36128 $ - $Date: 2005-10-25 08:25:36 -0200 (Tue, 25 Oct 2005) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Modela os dados para sincronizao entre dois projetos. Qualquer um deles
 * pode ser local ou remoto. Essa classe existe pelo simples fato de que as
 * informaes dos dois projetos devem ser enviadas para o servidor e depois
 * retornar com alteraes. Como a chamada  remota,  preciso retornar o
 * objeto via serializao. Ou seja, um objeto desta classe deve ser visto
 * como um mero agregador de dois ProjectSynchronizationUnits.
 */
public class ProjectSynchronizationData implements Serializable {
  private ProjectSynchronizationUnit unitA;
  private ProjectSynchronizationUnit unitB;

  /**
   * Constri um objeto de dados de sincronizao entre projetos contendo as
   * informaes de cada um dos projetos A e B.
   */
  public ProjectSynchronizationData(
    ProjectSynchronizationUnit unitA, ProjectSynchronizationUnit unitB) {
    this.unitA = unitA;
    this.unitB = unitB;
  }

  /**
   * Retorna os dados do projeto A.
   * @return dados do projeto A.
   */
  public ProjectSynchronizationUnit getUnitA() {
    return unitA;
  }

  /**
   * Retorna os dados do projeto B.
   * @return dados do projeto B.
   */
  public ProjectSynchronizationUnit getUnitB() {
    return unitB;
  }
}
