/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters;

import tecgraf.openbus.algorithmservice.v1_0.parameters.InputFileParameterHelper;

/**
 * Parmetro Arquivo de Entrada.
 *
 * @author lmoreira
 */
public class InputFileParameter extends FileParameter {
  /** Texto que representa o tipo desse parmetro */
  public static final String TYPE_VALUE = "INPUT_FILE";

  /**
   * Cria um parmetro do tipo arquivo de entrada.
   *
   * @param name O nome (No aceita {@code null}).
   * @param label O rtulo (No aceita {@code null}).
   * @param description A descrio do parmetro (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   * @param isOptional Indica se o parmetro  opcional.
   * @param isVisible Indica se o parmetro deve ficar visvel.
   * @param commandLinePattern O padro para construo da linha de comando. O
   *        padro ser utilizado para escrever o trecho da linha do comando
   *        referente ao parmetro. Esta string ser passada para o mtodo
   *        MessageFormat.format(String,Object...). O primeiro formato ({0}) 
   *        referente ao nome e o segundo formato ({1})  referente ao valor. Se
   *        {@code null} o parmetro no produzir sada na linha de comando.
   * @param types O tipo do arquivo aceito.
   * @param mode O modo de funcionamento do parmetro. ou seleo simples
   *        {@code false}.
   * @param usesPipe Indica se este parmetro pode aceitar pipe
   *        {@link FileParameterPipeAcceptance#TRUE}, no aceita pipe
   *        {@link FileParameterPipeAcceptance#FALSE} ou *s* aceita pipe
   *        {@link FileParameterPipeAcceptance#ALWAYS}.
   * @param usesFilter Indica se um painel para filtro deve ser exibido.
   */
  public InputFileParameter(String name, String label, String description,
    FileURLValue defaultValue, boolean isOptional, boolean isVisible,
    String commandLinePattern, String[] types, FileParameterMode mode,
    FileParameterPipeAcceptance usesPipe, boolean usesFilter) {
    super(name, label, description, defaultValue, isOptional, isVisible,
      commandLinePattern, types, mode, usesPipe, usesFilter, true);
  }

  /**
   * (non-Javadoc)
   *
   * @see csbase.logic.algorithms.parameters.SimpleParameter#getType()
   */
  @Override
  public String getType() {
    return TYPE_VALUE;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return InputFileParameterHelper.id();
  }

  /**
   *
   * {@inheritDoc}
   */
  @Override
  public boolean isOuput() {
    return false;
  }
}
