/*
 * $Id$
 */
package csbase.logic.algorithms.parameters.conditions;

import java.util.List;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * Condio "OU" (or) para a lista de condies.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class OrOperatorCondition extends CompositeOperatorCondition {

  /**
   * {@inheritDoc}
   * 
   * Mtodo OR: retorna true se alguma condio da lista for {@code true}.
   */
  @Override
  public boolean evaluate(final SimpleAlgorithmConfigurator configurator) {
    for (final Condition condition : getConditions()) {
      if (condition.evaluate(configurator)) {
        return true;
      }
    }
    return false;
  }

  /**
   * Construtor
   * 
   * @param conditions condies
   */
  public OrOperatorCondition(final Condition... conditions) {
    super(conditions);
  }

  /**
   * Construtor
   * 
   * @param conditions lista de condies
   */
  public OrOperatorCondition(final List<Condition> conditions) {
    super(conditions);
  }
}