package csbase.logic.server;

import java.io.Serializable;

import csbase.logic.ServerURI;

/**
 * <p>
 * Encapsula as informaes usadas na criao ou modificao de um
 * {@link ServerInfo}.
 * </p>
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ServerInfoData implements Serializable {
  /** O nome do servidor.*/
  private String name;

  /** Indica se o servidor est suspenso. */
  private boolean suspended;

  /** Indica se esse servidor  tambm um servidor local */
  private boolean isLocal;
  
  /** URI do servidor */
  private ServerURI uri;

  /**
   * Construtor.
   *
   * @param name O nome do servidor.
   * @param suspended Indica se o servidor est suspenso.
   * @param isLocal Indica se o servidor tambm  local.
   * @param uri A URI para conexo com o servidor.
   */
  public ServerInfoData(String name, boolean suspended, boolean isLocal, ServerURI uri) {
    this.name = name;
    this.suspended = suspended;
    this.isLocal = isLocal;
    this.uri = uri;
  }

  /**
   * Obtm o nome do servidor.
   * 
   *
   * @return O nome do servidor. 
   */
  public String getName() {
    return this.name;
  }

  /**
   * Verifica se o servidor est suspenso ou no.
   *
   * @return true, caso o servidor esteja suspenso, ou false, caso
   *         contrrio.
   */
  public boolean isSuspended() {
    return this.suspended;
  }

  /**
   * Verifica se o servidor  local.
   * 
   * @return true se representa um servidor local.
   */
  public boolean isLocal() {
    return this.isLocal;
  }
  
  /**
   * Obtm a URI do servidor.
   * 
   * @return A URI para do servidor.
   */
  public ServerURI getURI() {
    return this.uri;
  }
}
