/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;

public final class ReflectionExpressionFunction
extends ExpressionFunction {
    private Method method;

    public ReflectionExpressionFunction(Method method) {
        super(method.getName(), method.getParameterTypes());
        if (!Modifier.isPublic(method.getModifiers())) {
            String errorMessage = MessageFormat.format("O m\u00e9todo {0} n\u00e3o \u00e9 p\u00fablico.\nApenas m\u00e9todos p\u00fablicos podem ser utilizados.", method.getName());
            throw new IllegalArgumentException(errorMessage);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            String errorMessage = MessageFormat.format("O m\u00e9todo {0} n\u00e3o \u00e9 est\u00e1tico.\nApenas m\u00e9todos est\u00e1ticos podem ser utilizados.", method.getName());
            throw new IllegalArgumentException(errorMessage);
        }
        this.method = method;
    }

    @Override
    protected Object doOperation(SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException {
        try {
            return this.method.invoke(null, parameters);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionFunctionExecutionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionFunctionExecutionException(e.getTargetException());
        }
    }
}

