package csbase.logic.algorithms.parameters;

import tecgraf.javautils.core.lng.LNG;

/**
 * Define o conjunto de protocolos disponveis para uso no parmetro
 * {@link URLParameter}.
 */
public enum URLProtocol {

  /** Protocolo para URLs que apontam para a rea de projetos. */
  PROJECT("project", null),
  /** Protocolo para URLs que apontam para a arquivos locais ao cliente. */
  LOCAL("local", null),
  /** Protocolo para URLs que apontam para a arquivos do SGA. */
  SGA("sga", null);

  /**
   * Tipo do protocolo.
   */
  private String type;

  /**
   * O valor do protocolo na linha de comando.
   */
  private String commandValue;

  /**
   * Construtor.
   * 
   * @param type o tipo do protocolo.
   * @param commandValue valor do protocolo na linha de comando.
   */
  URLProtocol(String type, String commandValue) {
    this.type = type;
    this.commandValue = commandValue;
  }

  /**
   * Obtm o label do protocolo.
   * 
   * @return o label.
   */
  public String getDisplayName() {
    return LNG.get(URLProtocol.class.getSimpleName() + "." + type);
  }

  /**
   * Obtm o tipo do protocolo.
   * 
   * @return o tipo.
   */
  public String getType() {
    return type;
  }

  /**
   * Obtm o valor do protocolo na linha de comando ou nulo caso no tenha
   * valor.
   * 
   * @return o valor na linha de comando ou <code>null</code>.
   */
  public String getCommandValue() {
    return commandValue;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getDisplayName();
  }

}
