/**
 * $Id: DiagnosticServiceInterface.java 152996 2014-05-30 13:26:14Z mjulia $
 */
package csbase.remote;

import java.rmi.RemoteException;
import java.util.Map;

import csbase.logic.diagnosticservice.CommandExecutionStatisticsInfo;
import csbase.logic.diagnosticservice.DeploymentInfo;
import csbase.logic.diagnosticservice.LoginStatisticsInfo;
import csbase.logic.diagnosticservice.PropertyInfo;
import csbase.logic.diagnosticservice.ServerBasicInfo;
import csbase.logic.diagnosticservice.ServerDiagnosticInfo;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.UsersStatisticsInfo;

/**
 * Interface do servio de Diagnstico do servidor
 * 
 * @author Tecgraf
 */
public interface DiagnosticServiceInterface extends ServiceInterface {

  /** Nome do servio para o <code>ServiceManager</code> */
  public static final String SERVICE_NAME = "DiagnosticService";

  /**
   * Nome do recurso Openbus
   */
  public static final String OPENBUS_RESOURCE = "openbus";

  /**
   * Nome do recurso disco
   */
  public static final String SERVER_DISK_RESOURCE =
    DiskUsageServiceInterface.DIR_SERVER_ID;

  /**
   * Nome do recurso CSFS
   */
  public static String CSFS_RESOURCE = "csfs";

  /**
   * Obtm as todas as informaes de diagnstico do servidor.
   * 
   * @return as informaes de diagnstico do servidor
   * 
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public ServerDiagnosticInfo getServerDiagnosticInfo() throws RemoteException;

  /**
   * Obtm o estado de um recurso.
   * 
   * @param resourceName o nome com o qual o recurso est definido
   * @return a estado do recurso
   * 
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public Status getStatus(String resourceName) throws RemoteException;

  /**
   * Obtm informaes bsicas do servidor.
   * 
   * @return informaes bsicas sobre o servidor em execuo.
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public ServerBasicInfo getServerBasicInfo() throws RemoteException;

  /**
   * Obtm informaes estatsticas dos usurios.
   * 
   * @return informaes estatsticas sobre os usurios do sistema.
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public UsersStatisticsInfo getUsersStatisticsInfo() throws RemoteException;

  /**
   * Obtm as informaes estatsticas de login dos usurios.
   * 
   * @return informaes estatsticas de login dos usurios com os logins com
   *         sucesso e com as falhas nas autenticaes.
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public LoginStatisticsInfo getLoginStatisticsInfo() throws RemoteException;

  /**
   * Obtm informaes estatsticas de submisso de comandos. Essas informaes
   * so contabilizadas desde a ltima inicializao do servidor.
   * 
   * @return informaes estatsticas de submisso de comandos
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public CommandExecutionStatisticsInfo getCommandExecutionStatisticsInfo()
    throws RemoteException;

  /**
   * Obtm informaes sobre o ambiente de instalao do servidor.
   * 
   * @return informaes sobre o ambiente de instalao do servidor.
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public DeploymentInfo getDeploymentInfo() throws RemoteException;

  /**
   * Obtm informaes sobre as propriedades definidas para o servidor.
   * 
   * @return informaes sobre as propriedades.
   * @throws RemoteException se houver falha na comunicao RMI
   */
  public Map<String, PropertyInfo> getPropertiesInfo() throws RemoteException;
}
