package csbase.logic.algorithms.parsers;

import java.util.Collections;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * <p>
 * Analisador de {@link DoubleParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo real. O elemento corrente
 * do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link DoubleParameter}.
 * </p>
 */
public class DoubleParameterFactory extends
  AbstractDoubleParameterParser<DoubleParameter> {

  /**
   * <p>
   * O elemento {@value #DOUBLE_PARAMETER_ELEMENT}: descreve as propriedades de
   * um {@link DoubleParameter parmetro do tipo real}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String DOUBLE_PARAMETER_ELEMENT = "real";

  /**
   * {@inheritDoc}
   */
  @Override
  public DoubleParameter createDoubleParameter(XmlParser parser, String name,
    String label, String description, boolean isOptional, boolean isVisible,
    String commandLinePattern, Double maximum, boolean isMaximumIncluded,
    Double minimum, boolean isMinimumIncluded) throws ParseException {
    Double defaultValue = parser.extractAttributeValueAsDouble(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null, maximum, minimum);
    return new DoubleParameter(name, label, description, defaultValue,
      isOptional, isVisible, commandLinePattern, maximum, isMaximumIncluded,
      minimum, isMinimumIncluded);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    return Collections.singletonList(DoubleParameter.class);
  }
}
