/*
 * $Id: DBManagerServiceInterface.java 104195 2010-04-13 17:37:23Z clinio $
 */

package csbase.remote;

import java.sql.Connection;

/**
 * Define a interface remota do servio de gerenciamanto das conexes com o
 * banco dados.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface DBManagerServiceInterface {
  /**
   * Nome do servio para o <code>ServiceManager</code>
   */
  public static final String SERVICE_NAME = "DBManagerService";

  /**
   * Obtm uma conexo com o banco de dados. Usa a implementao do DBPool
   * 
   * @param driver o driver do banco de dados utilizado.
   * @param url a url do banco de dados.
   * @param user a chave do usurio do banco de dados.
   * @param password a senha do usurio do banco de dados.
   * 
   * @return uma conexo com o banco de dados.
   */
  public Connection getConnection(String driver, String url, String user,
    String password);

  /**
   * Obtm uma conexo com o banco de dados .
   * 
   * @param clazz A classe que implementa o pool.
   * @param driver o driver do banco de dados utilizado.
   * @param url a url do banco de dados.
   * @param user a chave do usurio do banco de dados.
   * @param password a senha do usurio do banco de dados.
   * 
   * @return uma conexo com o banco de dados.
   */
  public Connection getConnection(Class<?> clazz, String driver, String url,
    String user, String password);

  /**
   * Devolve uma conexo com banco de dados para o pool, tornando-a disponvel
   * novamente.
   * 
   * @param conn A conexo a ser devolvida.
   */
  public void releaseConnection(Connection conn);
}
