/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.TextParameterValidator;
import java.text.MessageFormat;
import java.util.List;
import tecgraf.openbus.algorithmservice.v1_0.parameters.TextListParameterHelper;

public final class TextListParameter
extends ListParameter<String> {
    private Integer maxCharacters;

    public TextListParameter(String name, String label, String description, List<String> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Integer maxCharacters) {
        super(name, label, description, defaultValue, isOptional, isVisible, false, true, commandLinePattern);
        this.setMaxCharacters(maxCharacters);
    }

    @Override
    protected String getItemValueFromText(String itemValue) {
        return itemValue;
    }

    @Override
    public String getType() {
        return "LIST_OF_TEXTS";
    }

    @Override
    public String getIDLType() {
        return TextListParameterHelper.id();
    }

    public Integer getMaxCharacters() {
        return this.maxCharacters;
    }

    private void setMaxCharacters(Integer maxCharacters) {
        if (maxCharacters != null && maxCharacters <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("O par\u00e2metro maxCharacters deveria ser positivo.\nValor encontrado: {0}.", maxCharacters));
        }
        this.maxCharacters = maxCharacters;
    }

    protected TextParameterValidator createItemValidator() {
        return new TextParameterValidator(this.isOptional(), this.maxCharacters);
    }
}

