package csbase.exception;

/**
 * A classe <code>UnavailableServiceException</code> representa uma falha
 * durante a execuo de um pedido de servio, devido  indisponibilidade
 * deste servio.
 *
 * Esse tipo de falha pode ou no estar associada a uma descrio especfica.
 * Se houver descrio, a mesma deve ser adequada para exibio ao usurio.
 */
public class UnavailableServiceException extends CSBaseRuntimeException {

  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  public UnavailableServiceException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * @param message a descrio do erro
   */
  public UnavailableServiceException(String message) {
    super(message);
  }
}
