package csbase.logic;

import tecgraf.javautils.core.lng.LNG;

/**
 * Enumerao que define os tipos de arquivos {@link ClientFile} quanto a sua
 * localizao. Atualmente, existem apenas 3 tipos: Local (arquivo na mquina do
 * usurio), SGA (arquivo na mquina do SGA) e Remoto (arquivo de projeto do
 * usurio).
 * 
 * @author Tecgraf
 */
public enum ClientFileType {

  /**
   * Item de enumerao que indica que um {@link ClientFile}  um arquivo local.
   */
  LOCAL,

  /**
   * Item de enumerao que indica que um {@link ClientFile}  um arquivo
   * localizado na mquina do SGA.
   */
  SGA,

  /**
   * Item de enumerao que indica que um {@link ClientFile}  um arquivo de
   * projeto.
   */
  REMOTE;

  /**
   * Monta um texto internacionalizado com um rtulo para esse tipo.
   * 
   * @return o texto
   */
  final public String getLabel() {
    final String classPrefix = getClass().getSimpleName();
    final String name = super.name();
    final String prefix = classPrefix + "." + name;
    final String key = prefix + ".label";
    if (!LNG.hasKey(key)) {
      return name;
    }
    final String text = LNG.get(key);
    return text;
  }
}
