/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.User;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.FileLockedException;
import tecgraf.ftc.common.exception.MaxClientsReachedException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.ftc.common.logic.RemoteFileChannelImpl;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

public class SyncRemoteFileChannel
implements RemoteFileChannel {
    private static final long FAILURE_WAIT = 500L;
    private static final int MAX_FAILURES = 20;
    private byte[] id = null;
    private RemoteFileChannel channel = null;

    public SyncRemoteFileChannel(RemoteFileChannelInfo info) {
        this.id = info.getIdentifier();
        this.channel = new RemoteFileChannelImpl(info);
    }

    public SyncRemoteFileChannel(byte[] id, boolean writable, String host, int port, byte[] key) {
        this.id = id;
        this.channel = new RemoteFileChannelImpl(id, writable, host, port, key);
    }

    public SyncRemoteFileChannel(RemoteFileChannel channel) {
        this.id = channel.toString().getBytes();
        this.channel = channel;
    }

    public boolean open(boolean readOnly) throws PermissionException, FileNotFoundException, FailureException, MaxClientsReachedException {
        User user = User.getLoggedUser();
        String realUser = (String)user.getAttribute("realUser");
        realUser = realUser != null ? ", realUser: " + realUser : "";
        String dmsg = String.format("[SRFC] op: OPEN, ulogin: %s, uname: %s%s, channelId: %s", user.getLogin(), user.getName(), realUser, DatatypeConverter.printHexBinary((byte[])this.id));
        Object[] trace = Thread.currentThread().getStackTrace();
        System.out.println("--------------------------------------------------------------------------------");
        System.out.println(dmsg + "\n\t" + Arrays.toString(trace));
        return this.channel.open(readOnly);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws FailureException {
        this.channel.close();
        System.out.println("[SRFC] op: CLOSE, channelId: " + DatatypeConverter.printHexBinary((byte[])this.id));
    }

    public long getPosition() {
        return this.channel.getPosition();
    }

    public void setPosition(long position) throws FailureException {
        this.channel.setPosition(position);
    }

    public long getSize() {
        return this.channel.getSize();
    }

    public void setSize(long size) throws PermissionException, FailureException {
        this.channel.setSize(size);
    }

    public int read(byte[] target) throws FailureException {
        return this.read(target, 0, target.length, 0L);
    }

    public int read(byte[] target, long position) throws FailureException {
        return this.read(target, 0, target.length, position);
    }

    public int read(byte[] target, int offset, int length) throws FailureException {
        return this.read(target, 0, target.length, 0L);
    }

    public int read(byte[] target, int offset, int length, long position) throws FailureException {
        int avail = (int)Math.min((long)length, this.channel.getSize() - position);
        return this.channel.read(target, offset, avail, position);
    }

    public int syncRead(byte[] target, int offset, int length, long position) throws FailureException {
        long size = this.channel.getSize();
        if (size > -1L) {
            length = (int)Math.min((long)length, size - position);
        }
        int transfered = 0;
        int numFailures = 0;
        while (transfered < length) {
            int part = this.channel.read(target, offset + transfered, length - transfered, position + (long)transfered);
            transfered += part;
            if (part != 0) continue;
            if (++numFailures > 20) {
                throw new FailureException("Sem retorno do servidor ao solicitar dados do arquivo " + new String(this.id));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return transfered;
    }

    public int write(byte[] source) throws PermissionException, FailureException, FileLockedException {
        return this.channel.write(source);
    }

    public int write(byte[] source, long position) throws PermissionException, FailureException, FileLockedException {
        return this.channel.write(source, position);
    }

    public int write(byte[] source, int offset, int length) throws PermissionException, FailureException, FileLockedException {
        return this.channel.write(source, offset, length);
    }

    public int write(byte[] source, int offset, int length, long position) throws PermissionException, FailureException, FileLockedException {
        return this.channel.write(source, offset, length, position);
    }

    public void syncWrite(byte[] source, int offset, int length, long position) throws PermissionException, FailureException, FileLockedException {
        int transfered = 0;
        int numFailures = 0;
        while (transfered < length) {
            int part = this.channel.write(source, offset + transfered, length - transfered, position + (long)transfered);
            transfered += part;
            if (part != 0) continue;
            if (++numFailures > 20) {
                throw new FailureException("Sem retorno do servidor ao enviar dados para o arquivo " + new String(this.id));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public long transferTo(long position, long count, OutputStream target) throws FailureException {
        return this.channel.transferTo(position, count, target);
    }

    public long syncTransferTo(long position, long count, OutputStream target) throws FailureException {
        count = Math.min(count, this.getSize() - position);
        long transfered = 0L;
        int numFailures = 0;
        while (transfered < count) {
            long part = this.channel.transferTo(position + transfered, count - transfered, target);
            transfered += part;
            if (part != 0L) continue;
            if (++numFailures > 20) {
                throw new FailureException("Sem retorno do servidor ao enviar dados do arquivo " + new String(this.id));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return transfered;
    }

    public long transferTo(long position, long count, RemoteFileChannel target) throws PermissionException, FailureException, FileLockedException {
        return this.channel.transferTo(position, count, target);
    }

    public long syncTransferTo(long position, long count, RemoteFileChannel target) throws PermissionException, FailureException, FileLockedException {
        count = Math.min(count, this.getSize() - position);
        long transfered = 0L;
        int numFailures = 0;
        while (transfered < count) {
            long part = this.channel.transferTo(position + transfered, count - transfered, target);
            transfered += part;
            if (part != 0L) continue;
            if (++numFailures > 20) {
                throw new FailureException("Sem retorno do servidor ao enviar dados do arquivo " + new String(this.id));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return transfered;
    }

    public long transferFrom(InputStream source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        return this.channel.transferFrom(source, position, count);
    }

    public long syncTransferFrom(InputStream source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        long transfered = 0L;
        int numFailures = 0;
        while (transfered < count) {
            long part = this.channel.transferFrom(source, position + transfered, count - transfered);
            transfered += part;
            if (part != 0L) continue;
            int b = 0;
            try {
                b = source.read();
            }
            catch (IOException e) {
                throw new FailureException((Throwable)e);
            }
            if (b == -1) {
                return transfered;
            }
            byte[] barray = new byte[]{(byte)(b & 0xFF)};
            this.syncWrite(barray, 0, 1, position + transfered);
            ++transfered;
            if (part != 0L) continue;
            if (++numFailures > 20) {
                throw new FailureException("Sem retorno do servidor ao enviar para o arquivo " + new String(this.id));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return transfered;
    }

    public long transferFrom(RemoteFileChannel source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        return this.channel.transferFrom(source, position, count);
    }

    public long syncTransferFrom(RemoteFileChannel source, long position, long count) throws PermissionException, FailureException, FileLockedException {
        count = Math.max(count, source.getSize() - source.getPosition());
        long transfered = 0L;
        int numFailures = 0;
        while (transfered < count) {
            long part = this.channel.transferFrom(source, position + transfered, count - transfered);
            transfered += part;
            if (part != 0L) continue;
            if (++numFailures > 20) {
                throw new FailureException("Sem retorno do servidor ao enviar para o arquivo " + new String(this.id));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return transfered;
    }
}

