/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForDoublesTrigger;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForIntegersTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.AbstractSimpleTriggerFactory;

public final class ChangeMaximumTriggerFactory
extends AbstractSimpleTriggerFactory {
    private static final String INCLUDE_NEW_MAXIMUM_ATTRIBUTE = "incluir_novo_maximo";
    private static final boolean INCLUDE_NEW_MAXIMUM_DEFAULT_VALUE = true;
    private static final String NEW_MAXIMUM_ATTRIBUTE = "novo_maximo";

    public ChangeMaximumTriggerFactory() {
        super("trocar_maximo", false);
    }

    @Override
    protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition, Parameter<?> parameter, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Trigger trigger;
        if (parameter instanceof DoubleParameter) {
            Double maximum = parser.extractAttributeValueAsDouble(NEW_MAXIMUM_ATTRIBUTE, null);
            boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(INCLUDE_NEW_MAXIMUM_ATTRIBUTE, true);
            DoubleParameter doubleParameter = (DoubleParameter)parameter;
            trigger = new ChangeMaximumForDoublesTrigger(doubleParameter, condition, maximum, isMaximumIncluded);
        } else if (parameter instanceof DoubleListParameter) {
            Double maximum = parser.extractAttributeValueAsDouble(NEW_MAXIMUM_ATTRIBUTE, null);
            boolean isMaximumIncluded = parser.extractAttributeValueAsBoolean(INCLUDE_NEW_MAXIMUM_ATTRIBUTE, true);
            DoubleListParameter doubleListParameter = (DoubleListParameter)parameter;
            trigger = new ChangeMaximumForDoublesTrigger(doubleListParameter, condition, maximum, isMaximumIncluded);
        } else if (parameter instanceof IntegerParameter) {
            Integer maximum = parser.extractAttributeValueAsInteger(NEW_MAXIMUM_ATTRIBUTE, null);
            IntegerParameter integerParameter = (IntegerParameter)parameter;
            trigger = new ChangeMaximumForIntegersTrigger(integerParameter, condition, maximum);
        } else if (parameter instanceof IntegerListParameter) {
            Integer maximum = parser.extractAttributeValueAsInteger(NEW_MAXIMUM_ATTRIBUTE, null);
            IntegerListParameter integerListParameter = (IntegerListParameter)parameter;
            trigger = new ChangeMaximumForIntegersTrigger(integerListParameter, condition, maximum);
        } else {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2};\n{3};\n{4}.", parameter.getName(), "real", "lista_de_reais", "inteiro", "lista_de_inteiros");
        }
        return trigger;
    }
}

