/**
 * $Id$
 */
package csbase.exception;

import java.text.MessageFormat;

/**
 * 
 * A classe <code>InfoException</code> representa uma situao em que no foi
 * possvel atender o pedido do cliente, mas no devido a um erro, mas a uma
 * condio previsvel. Deve ser usada quando  preciso enviar uma mensagem de
 * informao ao cliente que no represente um erro no servidor. O texto da
 * mensagem deve estar traduzido e adequado para exibio ao usurio.
 * 
 * @author Tecgraf
 */
public class InfoException extends CSBaseRuntimeException {

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param clientMessage a descrio do erro
   */
  public InfoException(String clientMessage) {
    super(clientMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param clientMessage a descrio do erro
   * @param detailMessage mensagem internacionalizada para ser mostrada no
   *        cliente
   */
  public InfoException(String clientMessage, String detailMessage) {
    super(clientMessage, detailMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   * 
   * @see MessageFormat
   */
  public InfoException(String pattern, Object... arguments) {
    super(pattern, arguments);
  }

}
