/**
 * $Id$
 */
package csbase.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * Esta classe representa a permisso de logar como. Cada atributo est no
 * formato: [usurio corporativo]=[lista de usurios individuais separados por
 * vrgula]. Exemplo: albacora=lchaves,costa,karla. Ou seja, lchaves, costa e
 * karla podem logar como albacora
 *
 * @author Tecgraf
 */
public class LoginAsPermission extends AttributesPermission {

  /**
   * Constri uma permisso para logar como.
   */
  public LoginAsPermission() {
    super();
  }

  /**
   * Constri uma permisso para logar como.
   *
   * @param name nome da permisso
   * @param description descrio
   * @param attributes atributos da permisso
   */
  public LoginAsPermission(String name, String description,
    String[] attributes) {
    super(name, description, attributes);
  }

  /**
   * Varre os atributos (lista de usurios que podem logar como outros usurios)
   * devolvendo true se e somente se o realUserLogin puder logar como
   * newUserLogin.
   *
   * @param realUserLogin usurio real j logado
   * @param newUserLogin usurio para o qual se deseja logar
   * @return true se e somente se o realUserLogin puder logar como newUserLogin
   */
  public boolean canLoginAs(String realUserLogin, String newUserLogin) {
    boolean ret = false;
    for (String attr : attributes) {
      String corporateUser = attr.substring(0, attr.indexOf("="));
      if (corporateUser != null && corporateUser.equals(newUserLogin)) {
        String realUserList = attr.substring(attr.indexOf("=") + 1);
        if (realUserList != null) {
          StringTokenizer st = new StringTokenizer(realUserList, ",");
          while (st.hasMoreTokens()) {
            if (st.nextToken().equals(realUserLogin)) {
              ret = true;
              break;
            }
          }
        }
      }
    }
    return ret;
  }

  /**
   * Dado o login de um usurio, retorna todos os logins para o qual ele pode
   * logar ou uma lista vazia, se no puder logar como outro usurio
   *
   * @param realUserLogin login do usurio
   * @return todos os logins para o qual ele pode logar ou uma lista vazia, se
   *         no puder logar como outro usurio
   */
  public List<String> getAllowedLogins(String realUserLogin) {
    ArrayList<String> ret = new ArrayList<String>();
    for (String attr : attributes) {
      String corporateUser = attr.substring(0, attr.indexOf("="));
      if (corporateUser != null) {
        String realUserList = attr.substring(attr.indexOf("=") + 1);
        if (realUserList != null) {
          StringTokenizer st = new StringTokenizer(realUserList, ",");
          while (st.hasMoreTokens()) {
            if (st.nextToken().equals(realUserLogin)) {
              ret.add(corporateUser);
              break;
            }
          }
        }
      }
    }
    return ret;
  }

  /**
   *
   * Devolve true se e somente se todos os usurios denotados entre todos os
   * atributos existirem
   */
  @Override
  public boolean validate() {
    boolean ret = true;
    // Devem haver atributos
    if (attributes == null || attributes.length == 0) {
      return false;
    }
    for (String attr : attributes) {
      if (attr.indexOf("=") == -1) {
        ret = false;
        break;
      }
      String corporateUser = attr.substring(0, attr.indexOf("="));
      if (corporateUser != null) {
        if (getUserByLogin(corporateUser) == null) {
          ret = false;
          break;
        }
        String realUserList = attr.substring(attr.indexOf("=") + 1);
        if (realUserList != null) {
          StringTokenizer st = new StringTokenizer(realUserList, ",");
          while (st.hasMoreTokens()) {
            if (getUserByLogin(st.nextToken()) == null) {
              ret = false;
              break;
            }
          }
        }
      }
    }
    return ret;
  }

  /**
   * Mtodo facilitador para no ter que tratar a exceo no validate.
   *
   * @param login
   * @return null se o usurio denotado por login no existir ou se der exceo
   *         ou o usurio, caso ele exista
   */
  private User getUserByLogin(String login) {
    User ret = null;
    try {
      ret = User.getUserByLogin(login);
    }
    catch (Exception e) {
    }
    return ret;
  }
}
