/**
 * $Id$
 */

package csbase.logic;

import csbase.remote.RemoteEvent;

/**
 * Representa eventos que podem ocorrer em um projeto. Objetos dessa classe so
 * criados pelo servidor sempre que acontecer alguma modificao em um projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class ProjectEvent extends RemoteEvent {
  /** O evento de modificar informaes do projeto. */
  public static final int INFO_MODIFIED = 1;
  /** O evento de remoo do projeto. */
  public static final int PROJECT_DELETED = 2;
  /** O evento de incluir um arquivo na rvore do projeto. */
  public static final int NEW_FILE = 3;
  /** O evento de remover um arquivo da rvore do projeto. */
  public static final int FILE_DELETED = 4;
  /** O evento de renomear um arquivo. */
  public static final int NEW_FILE_NAME = 5;
  /**
   * O evento de mover um arquivo para um outro diretrio da rvore do projeto.
   */
  public static final int FILE_MOVED = 6;
  /** O evento de alterao do estado de um arquivo. */
  public static final int FILE_STATE_CHANGED = 7;
  /** O evento de atualizao da rvore do projeto. */
  public static final int TREE_CHANGED = 8;
  /** O evento de fechamento de um projeto */
  public static final int PROJECT_CLOSED = 9;
  /** O evento de remover vrios arquivos da rvore do projeto. */
  public static final int FILES_DELETED = 10;
  /**
   * O evento de incluir vrios arquivos simultaneamente na rvore do projeto.
   */
  public static final int NEW_FILES = 11;
  /** O evento de atualizao de um diretrio do projeto. */
  public static final int DIR_REFRESHED = 12;

  /**
   * Indica qual foi o evento ocorrido no servidor. Pode ser uma das constantes
   * definidas nessa classe.
   */
  public int event;

  /**
   * O identificador do projeto.
   */
  public Object projectId;

  /**
   * Cria um evento, deduzindo os parmetros de acordo com o tipo de evento.
   * 
   * @param projectId identificador do projeto
   * @param type tipo de evento.
   * @param args parmetros de acordo com o tipo de evento.
   * @return o evento criado.
   */
  public static ProjectEvent makeEvent(Object projectId, int type, Object[] args) {
    try {
      switch (type) {
        case INFO_MODIFIED:
          return new ProjectInfoModifiedEvent(projectId,
            (CommonProjectInfo) args[0]);
        case PROJECT_DELETED:
          return new ProjectDeletedEvent(args[0]);
        case NEW_FILE:
          return new NewProjectFileEvent(projectId, (String[]) args[0],
            (ClientProjectFile) args[1]);
        case NEW_FILES:
          return new NewProjectFilesEvent(projectId, (String[][]) args[0],
            (ClientProjectFile[]) args[1]);
        case FILE_DELETED:
          return new ProjectFileDeletedEvent(projectId, (String[]) args[0]);
        case NEW_FILE_NAME:
          return new ProjectFileRenamedEvent(projectId, (String[]) args[0],
            (String) args[1], (String) args[2]);
        case FILE_MOVED:
          return null;
        case FILE_STATE_CHANGED:
          return new ProjectFileStateChangedEvent(projectId,
            (String[]) args[0], (String) args[1], (Boolean) args[2],
            ((Long) args[3]).longValue(), ((Long) args[4]).longValue(),
            (Boolean) args[5]);
        case TREE_CHANGED:
          return new TreeChangedEvent(projectId, (ClientProjectFile) args[0]);
        case DIR_REFRESHED:
          return new DirRefreshedEvent(projectId, (String[]) args[0],
            (ClientProjectFile) args[1]);
        case PROJECT_CLOSED:
          return new ProjectClosedEvent(projectId);
        case FILES_DELETED:
          return new ProjectFilesDeletedEvent(projectId, (String[][]) args[0]);
        default:
          return null;
      }
    }
    catch (Exception e) {
      return null;
    }
  }
}
