/**
 * $Id$
 */

package csbase.logic;

import tecgraf.javautils.core.io.FileUtils;

/**
 * Representa o evento de mudana de estado de um arquivo na rvore do projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectFileStateChangedEvent extends ProjectEvent {
  /**
   * O caminho do arquivo
   */
  private String[] path;
  /**
   * O nome do arquivo
   */
  private String name;
  /**
   * Indica que o arquivo est em construo
   */
  private boolean isUnderConstruction;
  /**
   * O arquivo
   */
  private ClientProjectFile file;
  /**
   * 
   */
  private long modificationDate;
  /**
   * 
   */
  private long size;
  /**
   * Indica se o arquivo est bloqueado
   */
  private boolean isLocked;

  /**
   * Retorna o caminho do arquivo cujo estado foi alterado.
   * 
   * @return O caminho do arquivo.
   */
  public String[] getPath() {
    return path;
  }

  /**
   * Retorna o nome do arquivo cujo estado foi alterado.
   * 
   * @return O caminho do arquivo.
   */
  public String getName() {
    return name;
  }

  /**
   * Informa se o arquivo est em construo.
   * 
   * @return true se est em construo, false caso contrrio.
   */
  public boolean isUnderConstruction() {
    return isUnderConstruction;
  }

  /**
   * Retorna o tamanho atualizado do arquivo.
   * 
   * @return O tamanho atualizado do arquivo.
   */
  public long getSize() {
    return size;
  }

  /**
   * Retorna a data de modificao atualizada do arquivo.
   * 
   * @return a data de modificao atualizada do arquivo.
   */
  public long getModificationDate() {
    return modificationDate;
  }

  /**
   * Indica se o arquivo est bloqueado
   * 
   * @return true se o arquivo estiver bloqueado
   */
  public boolean isLocked() {
    return isLocked;
  }

  /**
   * Atribui o arquivo cujo estado foi alterado.
   * 
   * @param file O arquivo cujo estado foi alterado.
   */
  public void setFile(ClientProjectFile file) {
    this.file = file;
  }

  /**
   * Retorna o arquivo cujo estado foi alterado.
   * 
   * @return O arquivo cujo estado fo alterado.
   */
  public ClientProjectFile getFile() {
    return file;
  }

  /**
   * Cria uma instncia de <code>ProjectEvent</code> para o evento de mudana de
   * estado de um arquivo na rvore de um projeto.
   * 
   * @param projectId o identificador do projeto
   * @param path O caminho do arquivo cujo estado foi alterado.
   * @param name nome do arquivo
   * @param isUnderConstruction se o arquivo est em construo.
   * @param modificationDate da de modificao do arquivo
   * @param size tamanho do arquivo
   * @param isLocked indica se o arquivo est bloqueado
   */
  public ProjectFileStateChangedEvent(Object projectId, String[] path,
    String name, boolean isUnderConstruction, long modificationDate, long size,
    boolean isLocked) {
    event = FILE_STATE_CHANGED;
    this.projectId = projectId;
    this.path = path;
    this.name = name;
    this.isUnderConstruction = isUnderConstruction;
    this.modificationDate = modificationDate;
    this.size = size;
    this.isLocked = isLocked;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return "FILE_STATE_CHANGED: path = " + FileUtils.joinPath('/', path)
      + ", name = " + name + ", isUnderConstruction = " + isUnderConstruction
      + ", modificationDate = " + modificationDate + ", size = " + size
      + ", isLocked = " + isLocked;
  }
}
